/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.common.iolog.DigitalInputChannelEvent;
import com.integ.common.iolog.IoChannelEvent;
import com.integ.common.iolog.IoChannelLogListener;
import com.integ.common.logging.AppLog;
import com.integ.common.system.UnitConfig;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.registry.RegistryListener;
import com.integpg.system.JANOS;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigitalInputs
implements IoChannelLogListener,
RegistryListener {
    private static final Pattern REGISTRY_INPUTS_PATTERN = Pattern.compile("io/inputs/din(\\d+)/.*", 1);
    private final MqttClient _mqttClient;

    public DigitalInputs(MqttClient mqttClient) {
        this._mqttClient = mqttClient;
    }

    public void reportCurrentStates() {
        int inputStates = JANOS.getInputStates();
        for (int i = 1; i <= UnitConfig.getInputCount(); ++i) {
            try {
                boolean state = 1 == (inputStates & 1);
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/inputs/" + i + "/state", String.valueOf(state).getBytes(), true);
                long usageMeter = JANOS.getUsageMeter((int)(i - 1));
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/inputs/" + i + "/usagemeter", String.valueOf((double)usageMeter / 3600000.0).getBytes(), true);
                int counter = JANOS.getInputCounter((int)(i - 1));
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/inputs/" + i + "/counter", String.valueOf(counter).getBytes(), true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        try {
            System.out.println("input changed");
            DigitalInputChannelEvent digitalInputEvent = (DigitalInputChannelEvent)ioEvent;
            if (null != this._mqttClient) {
                String digitalInputTopicPrefix = String.format("%sdigital/inputs/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, digitalInputEvent.Channel);
                this._mqttClient.publish(String.format("%s/state", digitalInputTopicPrefix), String.valueOf(digitalInputEvent.State).getBytes(), true);
                this._mqttClient.publish(String.format("%s/usagemeter", digitalInputTopicPrefix), String.valueOf((double)digitalInputEvent.UsageMeter / 3600000.0).getBytes(), true);
                if (digitalInputEvent.State) {
                    this._mqttClient.publish(String.format("%s/counter", digitalInputTopicPrefix), String.valueOf(digitalInputEvent.Counter).getBytes(), true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void registryKeyUpdated(String registryKeyName) {
        block5: {
            try {
                Matcher matcher = REGISTRY_INPUTS_PATTERN.matcher(registryKeyName);
                boolean found = matcher.find();
                if (!found) break block5;
                try {
                    int channel = Integer.parseInt(matcher.group(1));
                    String regValue = JANOS.getRegistryString((String)registryKeyName, (String)"");
                    String digitalInputTopicPrefix = String.format("%sdigital/inputs/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, channel);
                    if (registryKeyName.endsWith("$HourMeter")) {
                        this._mqttClient.publish(String.format("%s/usagemeter", digitalInputTopicPrefix), regValue.getBytes());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                AppLog.error("error handling registry key update for " + registryKeyName + " in digital inputs", ex);
            }
        }
    }
}

