/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.externalmodules;

import com.integ.common.externalmodules.PresentDevices;
import com.integ.common.utils.HexUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;

public abstract class DeviceInfo {
    protected static final SensorPort SENSOR_PORT = new SensorPort();
    public final long DeviceAddress;
    public final String DeviceAddressString;
    public final int DeviceIndex;
    public byte[] DeviceBlock;
    public boolean Updated = false;
    public int FailureCount = 0;
    protected byte[] _savedBlock = null;
    protected int _significantDecimalPlaces = -1;
    protected String _precisionString = "%f";
    protected boolean _present = true;
    protected byte[] _writeBlock = null;
    protected int[] _rawIn;
    protected int[] _rawOut;
    protected final ArrayList<PropertyChangeListener> _propertyChangeListeners = new ArrayList();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null != propertyChangeListener) {
            this._propertyChangeListeners.add(propertyChangeListener);
        }
    }

    protected void alertPropertyChangeListeners(PropertyChangeEvent event) {
        if (0 != this._propertyChangeListeners.size()) {
            for (PropertyChangeListener listener : this._propertyChangeListeners) {
                listener.propertyChange(event);
            }
        }
    }

    public static long getModuleAddressAtIndex(String moduleType, int moduleIndex) {
        if (1 > moduleIndex) {
            throw new RuntimeException(moduleType + " module index out of bounds: " + moduleIndex);
        }
        String deviceTypeString = moduleType + "_" + moduleIndex;
        System.out.println("deviceTypeString: " + deviceTypeString);
        String deviceTypeAddressKey = String.format("externals/deviceorder/%s", deviceTypeString);
        System.out.println("deviceTypeAddressKey: " + deviceTypeAddressKey);
        String deviceAddressString = JANOS.getRegistryString((String)deviceTypeAddressKey, (String)"").toUpperCase();
        System.out.println("deviceAddressString: " + deviceAddressString);
        if (!"".equals(deviceAddressString)) {
            long deviceAddress = HexUtils.parseHexAsLong(deviceAddressString);
            return deviceAddress;
        }
        return -1L;
    }

    public DeviceInfo(long deviceAddress, int index) {
        this.DeviceAddress = deviceAddress;
        String deviceAddressString = "0000000000000000" + Long.toHexString(deviceAddress);
        this.DeviceAddressString = deviceAddressString = deviceAddressString.substring(deviceAddressString.length() - 16);
        this.DeviceIndex = index;
    }

    public int getRawIn(int index) {
        if (0 > index || this._rawIn.length <= index) {
            throw new RuntimeException(this.DeviceAddressString + " getRawIn index out of bounds: " + index);
        }
        return this._rawIn[index];
    }

    public int getRawOut(int index) {
        if (0 > index || this._rawOut.length <= index) {
            throw new RuntimeException(this.DeviceAddressString + " getRawOut index out of bounds: " + index);
        }
        return this._rawOut[index];
    }

    public boolean isPresent() {
        boolean present = PresentDevices.isPresent(this.DeviceAddressString);
        System.out.println(this.DeviceAddressString + ".present: " + present);
        return present;
    }

    public void setPresent(boolean present) {
        this._present = present;
    }

    public void setSignificantDecimalPlaces(int decimalPlaces) {
        this._significantDecimalPlaces = decimalPlaces;
        this._precisionString = "%." + decimalPlaces + "f";
    }

    public byte[] read() {
        byte[] deviceBlock;
        block5: {
            deviceBlock = null;
            this.Updated = false;
            if (this._present) {
                try {
                    deviceBlock = SensorPort.readDeviceBlock((long)this.DeviceAddress);
                    if (null == this._savedBlock) {
                        this._savedBlock = new byte[deviceBlock.length];
                    }
                    boolean bl = this.Updated = !ArrayUtils.arrayComp((Object)this._savedBlock, (int)0, (Object)deviceBlock, (int)0, (int)deviceBlock.length);
                    if (this.Updated) {
                        ArrayUtils.arraycopy((Object)deviceBlock, (int)0, (Object)this._savedBlock, (int)0, (int)deviceBlock.length);
                        this.DeviceBlock = deviceBlock;
                    }
                    this.FailureCount = 0;
                }
                catch (IOException ex) {
                    ++this.FailureCount;
                    System.out.println(String.format("could not read %s device: %s %d times", this.DeviceAddressString, ex.getMessage(), this.FailureCount));
                    if (3 > this.FailureCount) break block5;
                    this._present = false;
                }
            }
        }
        return deviceBlock;
    }

    public abstract void update();

    public void commit() throws IOException {
        if (this._present) {
            try {
                System.out.println(String.format("write device %s", this.DeviceAddressString));
                SensorPort.writeDeviceBlock((long)this.DeviceAddress, (byte[])this._writeBlock);
                this.FailureCount = 0;
            }
            catch (IOException ex) {
                ++this.FailureCount;
                System.out.println(String.format("could not write %s device: %s %d times", this.DeviceAddressString, ex.getMessage(), this.FailureCount));
                if (3 <= this.FailureCount) {
                    this._present = false;
                }
                throw ex;
            }
        }
    }
}

