/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.logging;

import com.integ.common.logging.HalfBakFileLog;
import com.integ.common.logging.Logger;
import com.integ.common.system.Application;
import com.integ.common.utils.ExceptionUtils;
import com.integpg.system.JANOS;
import java.text.QuickDateFormat;

public class AppLog {
    private static final QuickDateFormat DATE_FORMAT = new QuickDateFormat("MM/dd/yy HH:mm:ss zzz");
    private static Logger _log;
    private static Logger _exceptionLog;
    private static Logger _debugLog;

    private static synchronized void ensureLogFile() {
        try {
            String appName = Application.getAppInstanceName();
            if (_log == null && appName != null) {
                _log = HalfBakFileLog.getLogger(appName).setMaxSizeKB(32);
            }
            if (_exceptionLog == null && appName != null) {
                _exceptionLog = HalfBakFileLog.getLogger(appName + "_exception").setMaxSizeKB(32);
            }
            if (_debugLog == null && appName != null) {
                _debugLog = HalfBakFileLog.getLogger(appName + "_debug").setMaxSizeKB(32);
            }
        }
        catch (Exception ex) {
            String stackTrace = ExceptionUtils.getStackTrace(ex);
            System.err.println(String.format("%s, %s", DATE_FORMAT.format(), stackTrace));
        }
    }

    public static Logger getLog() {
        return _log;
    }

    public static void setAppLog(Logger log) {
        _log = log;
    }

    public static void setAppExceptionLog(Logger log) {
        _exceptionLog = log;
    }

    public static void fatal(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.fatal(line);
        }
        JANOS.syslog((String)line, (int)2, (int)1);
    }

    public static void warn(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.warn(line);
        }
        AppLog.sendToSyslogServer(line, 4);
    }

    public static void error(String error) {
        AppLog.ensureLogFile();
        _log.error(error);
        AppLog.sendToSyslogServer(error, 3);
    }

    public static void error(Throwable ex) {
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        AppLog.ensureLogFile();
        _log.error(ex.getMessage());
        if (_exceptionLog != null) {
            _exceptionLog.error(stackTrace);
        } else {
            ex.printStackTrace(System.out);
        }
        AppLog.sendToSyslogServer(ex.toString(), 3);
    }

    public static void error(String description, Throwable ex) {
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        AppLog.ensureLogFile();
        _log.error(description + ":" + ex.getMessage());
        if (_exceptionLog != null) {
            _exceptionLog.error(description + ": " + stackTrace);
        } else {
            ex.printStackTrace(System.out);
        }
        AppLog.sendToSyslogServer(description + ": " + ex.toString(), 3);
    }

    private static void sendToSyslogServer(String message, int level) {
        JANOS.syslog((String)message, (int)level, (int)2);
    }

    public static void debug(String line) {
        AppLog.ensureLogFile();
        if (_debugLog != null) {
            _debugLog.debug(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static void info(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.info(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static void vital(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.vital(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }
}

