/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.system;

import com.integ.common.logging.AppLog;
import com.integ.common.system.Application;
import com.integpg.system.Watchdog;

public class ApplicationWatchdog
implements Runnable {
    private Watchdog _watchdog = new Watchdog(Application.getAppInstanceName());
    private Thread _thd;

    public ApplicationWatchdog(int watchdogAction) {
        this._watchdog.setAction(watchdogAction);
    }

    public void start() {
        if (null != this._watchdog && null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName(this.getClass().getName() + ":" + Application.getAppName());
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        AppLog.vital("Activate " + this._watchdog.getText() + " watchdog");
        this._watchdog.activate(120000);
        long lastFedTime = System.currentTimeMillis();
        try {
            while (true) {
                this._watchdog.refresh();
                long elapsed = System.currentTimeMillis() - lastFedTime;
                System.out.println("hit watchdog.  " + elapsed + " since last hit");
                lastFedTime = System.currentTimeMillis();
                Thread.sleep(60000L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    public void finalize() {
        AppLog.vital("Deactivate " + Application.getAppInstanceName() + " watchdog");
        this._watchdog.deactivate();
    }
}

