package com.integ.iolog;

import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.IoEvent;
import com.integpg.system.JANOS;

public class DigitalOutputIoLogMonitor extends IoLogMonitor {

    @Override
    public void alertIoListener(IoLogListener ioLogListener, IoEvent ioEvent) {
        for (int chan = 0; chan < UnitConfig.getOutputCount(); chan++) {
            if (1 == ((ioEvent.mask >> chan) & 1)) {
                int state = (ioEvent.states >> chan) & 1;
                System.out.println("@" + QUICK_DATE_FORMAT.format(ioEvent.timestamp)
                        + " channel " + (chan + 1)
                        + " is now " + (1 == state ? "HIGH" : "LOW"));

                DigitalOutputEvent digitalOutputEvent = new DigitalOutputEvent();
                digitalOutputEvent.Channel = (chan + 1);
                digitalOutputEvent.TransitionTime = ioEvent.timestamp;
                digitalOutputEvent.State = (1 == state);
                digitalOutputEvent.UsageMeter = JANOS.getUsageMeter(chan + UnitConfig.getInputCount());

                ioLogListener.onIoEvent(digitalOutputEvent);
            }
        }
    }



    @Override
    protected IoEvent[] getIoEvents() {
        return _iolog.getOutputEvents();
    }
}

