/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.mqtt.Config;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.outgoingpackets.PublishPacket;
import com.integ.registry.RegistryListener;
import com.integpg.janoslib.iolog.DigitalInputChannelEvent;
import com.integpg.janoslib.iolog.IoChannelEvent;
import com.integpg.janoslib.iolog.IoChannelLogListener;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.Iolog;
import com.integpg.system.JANOS;
import java.text.SimpleDateFormat;
import java.util.Json;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigitalInputs
implements IoChannelLogListener,
RegistryListener {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss.SSS");
    private static final Iolog IOLOG = new Iolog();
    private static final Pattern REGISTRY_INPUTS_PATTERN = Pattern.compile("io/inputs/din(\\d+)/.*", 1);
    private static final String[] ChannelPrefixes = new String[16];
    private static final Json[] JSONS = new Json[16];
    private final MqttClient _mqttClient;

    public DigitalInputs(MqttClient mqttClient) {
        this._mqttClient = mqttClient;
        for (int i = 0; i < 16; ++i) {
            DigitalInputs.ChannelPrefixes[i] = String.format("%sdigital/inputs/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, i + 1);
            DigitalInputs.JSONS[i] = new Json();
        }
    }

    public void reportCurrentStates() {
        int inputStates = JANOS.getInputStates();
        for (int i = 1; i <= UnitConfig.getInputCount(); ++i) {
            try {
                int payloadFormat = Config.getPayloadFormat();
                if (1 == payloadFormat || 3 == payloadFormat) {
                    boolean state = 1 == (inputStates & 1);
                    boolean latchedState = JANOS.isInputLatched((int)(i - 1));
                    this._mqttClient.publish(String.format("%s/state", ChannelPrefixes[i - 1]), String.valueOf(state).getBytes(), true);
                    long usageMeter = JANOS.getUsageMeter((int)(i - 1));
                    this._mqttClient.publish(String.format("%s/usagemeter", ChannelPrefixes[i - 1]), String.format("%.2f", (double)usageMeter / 3600000.0).getBytes(), true);
                    int counter = JANOS.getInputCounter((int)(i - 1));
                    this._mqttClient.publish(String.format("%s/counter", ChannelPrefixes[i - 1]), String.valueOf(counter).getBytes(), true);
                }
                if (2 != payloadFormat && 3 != payloadFormat) continue;
                this.updateJsonForInput(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        try {
            DigitalInputChannelEvent digitalInputEvent = (DigitalInputChannelEvent)ioEvent;
            if (null != this._mqttClient) {
                int payloadFormat = Config.getPayloadFormat();
                if (1 == payloadFormat || 3 == payloadFormat) {
                    this._mqttClient.publish(String.format("%s/state", ChannelPrefixes[digitalInputEvent.Channel - 1]), String.valueOf(digitalInputEvent.State).getBytes(), true);
                    this._mqttClient.publish(String.format("%s/usagemeter", ChannelPrefixes[digitalInputEvent.Channel - 1]), String.format("%.2f", (double)digitalInputEvent.UsageMeter / 3600000.0).getBytes(), true);
                    if (digitalInputEvent.State) {
                        this._mqttClient.publish(String.format("%s/counter", ChannelPrefixes[digitalInputEvent.Channel - 1]), String.valueOf(digitalInputEvent.Counter).getBytes(), true);
                    }
                }
                if (2 == payloadFormat || 3 == payloadFormat) {
                    this.updateJsonForInput(ioEvent.Channel);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void registryKeyUpdated(String registryKeyName) {
        block7: {
            try {
                Matcher matcher = REGISTRY_INPUTS_PATTERN.matcher(registryKeyName);
                boolean found = matcher.find();
                if (!found) break block7;
                try {
                    int channel = Integer.parseInt(matcher.group(1));
                    if (registryKeyName.endsWith("$HourMeter")) {
                        String regValue = JANOS.getRegistryString((String)registryKeyName, (String)"");
                        int payloadFormat = Config.getPayloadFormat();
                        if (1 == payloadFormat || 3 == payloadFormat) {
                            this._mqttClient.publish(String.format("%s/usagemeter", ChannelPrefixes[channel - 1]), regValue.getBytes());
                        }
                        if (2 == payloadFormat || 3 == payloadFormat) {
                            this.updateJsonForInput(channel);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                AppLog.error("error handling registry key update for " + registryKeyName + " in digital inputs", ex);
            }
        }
    }

    private void updateJsonForInput(int channel) {
        try {
            int channelIndex = channel - 1;
            int inputStates = JANOS.getInputStates();
            boolean state = 1 == (inputStates >> channelIndex & 1);
            JSONS[channelIndex].put("State", (Object)String.valueOf(state));
            long usageMeter = JANOS.getUsageMeter((int)channelIndex);
            JSONS[channelIndex].put("UsageMeter", (Object)String.format("%.2f", (double)usageMeter / 3600000.0));
            int counter = JANOS.getInputCounter((int)(channel - 1));
            JSONS[channelIndex].put("Counter", counter);
            IOLOG.refresh();
            if (state) {
                long[] lastHightime = IOLOG.getInputTransitions(channelIndex, 1, 1);
                if (0 < lastHightime.length) {
                    JSONS[channelIndex].put("TransitionTimestamp", lastHightime[0]);
                    JSONS[channelIndex].put("TransitionTime", (Object)DATE_FORMAT.format(lastHightime[0]));
                }
            } else {
                long[] lastLowtime = IOLOG.getInputTransitions(channelIndex, 0, 1);
                if (0 < lastLowtime.length) {
                    JSONS[channelIndex].put("TransitionTimestamp", lastLowtime[0]);
                    JSONS[channelIndex].put("TransitionTime", (Object)DATE_FORMAT.format(lastLowtime[0]));
                }
            }
            PublishPacket publishPacket = new PublishPacket(ChannelPrefixes[channel - 1], JSONS[channelIndex].toString().getBytes()).setRetainFlag(true);
            this._mqttClient.publish(publishPacket);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

