/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.JanosLib;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.system.AssemblyInfoBase;
import com.integpg.janoslib.system.EnvironmentHash;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.JDateFormat;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.ApplicationUtils;
import com.integpg.janoslib.utils.ExceptionUtils;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.system.JANOS;
import com.integpg.system.Watchdog;
import java.io.File;
import java.io.IOException;

public abstract class JanosApplication {
    public static long ApplicationStart = System.currentTimeMillis();
    private static final JDateFormat DATE_FORMAT = new JDateFormat().includeMilliseconds(true);
    private static String _registryRoot = "";
    private static boolean _isBackground = false;
    private static JanosApplication _janosApplication;
    private AssemblyInfoBase _assemblyInfo;
    private Watchdog _watchdog;

    protected JanosApplication() {
    }

    public abstract boolean shouldPreventDuplicateInstance();

    public final void configureWatchdog() {
        this._watchdog = new Watchdog(this._assemblyInfo.getName());
        this._watchdog.setAction(4);
        this._watchdog.setDuration(120000);
    }

    public abstract void init(String[] var1);

    public abstract void run() throws InterruptedException;

    public static String getName() {
        return JanosApplication._janosApplication._assemblyInfo.getName();
    }

    public static void exec(JanosApplication janosApplication, AssemblyInfoBase assemblyInfo, String[] args) {
        try {
            boolean bl;
            if (1 == args.length && "--version".equals(args[0])) {
                String string = String.format("%s v%s (built %s)\nusing JanosLib v%s (built %s)", assemblyInfo.getName(), assemblyInfo.getVersion(), assemblyInfo.getBuildTime(), JanosLib.getVersion(), JanosLib.getBuildTime());
                System.out.println(string);
                System.exit(0);
            }
            for (String arg : args) {
                if (!"-q".equals(arg)) continue;
                System.setOut(null);
                System.setErr(null);
            }
            _janosApplication = janosApplication;
            janosApplication._assemblyInfo = assemblyInfo;
            _registryRoot = String.format("AppData/%s/", assemblyInfo.getName());
            AppLog.init(assemblyInfo.getName());
            JANOS.setRegistryString((String)(_registryRoot + "$Name"), (String)janosApplication._assemblyInfo.getName());
            JANOS.setRegistryString((String)(_registryRoot + "$Version"), (String)janosApplication._assemblyInfo.getVersion());
            JANOS.setRegistryString((String)(_registryRoot + "$BuildTime"), (String)janosApplication._assemblyInfo.getBuildTime());
            JANOS.setRegistryString((String)(_registryRoot + "$JanosLibVersion"), (String)JanosLib.getVersion());
            JANOS.setRegistryString((String)(_registryRoot + "$JanosLibBuildTime"), (String)JanosLib.getBuildTime());
            JANOS.setRegistryString((String)(_registryRoot + "$ExecutionTime"), (String)String.valueOf(System.currentTimeMillis()));
            JANOS.setRegistryString((String)(_registryRoot + "$pid"), (String)String.valueOf(JANOS.getProcessID()));
            System.out.println("Environment size: " + EnvironmentHash.size());
            EnvironmentHash.put("appname", janosApplication._assemblyInfo.getName());
            System.out.println("Environment size: " + EnvironmentHash.size());
            System.out.println("appname: " + EnvironmentHash.get("appname"));
            _isBackground = ApplicationUtils.isBackground();
            janosApplication.logBanner();
            boolean bl2 = bl = !_isBackground;
            if (bl) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int runningInstances = JANOS.registerProcess((String)janosApplication._assemblyInfo.getName());
            if (janosApplication.shouldPreventDuplicateInstance() && 1 < runningInstances) {
                AppLog.error("another instance of " + janosApplication._assemblyInfo.getName() + " is running");
                System.exit(-1);
            }
            janosApplication.configureWatchdog();
            janosApplication.init(args);
            double elapsedSeconds = (double)(System.currentTimeMillis() - ApplicationStart) / 1000.0;
            AppLog.info(String.format("Application Loaded in %.2f seconds", elapsedSeconds));
            janosApplication.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            JanosApplication.fatal(exception);
        }
    }

    private void logBanner() {
        String versionString = String.format("%s v%s (built %s) using JanosLib v%s (built %s) running on JANOS %s", this._assemblyInfo.getName(), this._assemblyInfo.getVersion(), this._assemblyInfo.getBuildTime(), JanosLib.getVersion(), JanosLib.getBuildTime(), JANOS.getVersion());
        JANOS.syslog((String)versionString);
        AppLog.vital(versionString);
        AppLog.info(String.format("  %s[%d] running on S/N: %d, Model: %s", this._assemblyInfo.getName(), JANOS.getProcessID(), UnitConfig.SERIAL_NUMBER, UnitConfig.MODEL));
        this.updateBootLog(versionString);
    }

    private void updateBootLog(String versionString) {
        try {
            String entry = String.format("%s, %s\r\n", DATE_FORMAT.format(System.currentTimeMillis()), versionString);
            File bootlogFile = new File(this._assemblyInfo.getName().toLowerCase() + "_boot.log");
            if (16384L < bootlogFile.length() + (long)entry.length()) {
                File bakFile = new File(bootlogFile.getPath() + ".bak");
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                bootlogFile.renameTo(bakFile);
            }
            FileUtils.appendAllBytes(bootlogFile.getPath(), entry.getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void start() {
        try {
            this._watchdog.activate();
            this.run();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            JanosApplication.fatal(ex);
        }
    }

    protected void feedWatchdog() {
        this._watchdog.refresh();
    }

    public void runForever() {
        try {
            AppLog.info("sleep forever...");
            while (true) {
                this._watchdog.refresh();
                Thread.sleep(this._watchdog.getDuration() / 2);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
    }

    protected void exit(int code) {
        if (null != this._watchdog) {
            this._watchdog.deactivate();
        }
        System.exit(code);
    }

    public static void fatal(Object object) {
        JanosApplication.fatal(new RuntimeException(object.toString()));
    }

    public static void fatal(Exception ex) {
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        System.err.println(String.format("%s: %s", QuickDateFormat.getDefault().format(), stackTrace));
        System.exit(-1);
    }
}

