/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.common.externalmodules.EnvironSensor;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;

public class MqttEnvironSensor {
    private final MqttClient _mqttClient;
    private final EnvironSensor _environSensorDevice;

    public MqttEnvironSensor(MqttClient mqttClient, EnvironSensor environSensorDevice) {
        this._mqttClient = mqttClient;
        this._environSensorDevice = environSensorDevice;
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._environSensorDevice && this._environSensorDevice.isPresent()) {
                System.out.println("environ sensor device: " + this._environSensorDevice.DeviceAddressString);
                this._environSensorDevice.update();
                int channel = this._environSensorDevice.DeviceIndex;
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "environ/" + channel + "/celsius", (String.format("%.2f", this._environSensorDevice.getCelsius()) + " C").getBytes(), true);
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "environ/" + channel + "/fahrenheit", (String.format("%.2f", this._environSensorDevice.getFahrenheit()) + " F").getBytes(), true);
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "environ/" + channel + "/humidity", (String.format("%.2f", this._environSensorDevice.getHumidity()) + " %").getBytes(), true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

