/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.common.iolog.DigitalInputChannelEvent;
import com.integ.common.iolog.IoChannelEvent;
import com.integ.common.iolog.IoChannelLogListener;
import com.integ.common.logging.AppLog;
import com.integ.common.system.UnitConfig;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.registry.RegistryListener;
import com.integpg.system.JANOS;
import java.util.Json;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigitalInputs
implements IoChannelLogListener,
RegistryListener {
    private static final Pattern REGISTRY_INPUTS_PATTERN = Pattern.compile("io/inputs/din(\\d+)/.*", 1);
    private static final Json[] JSONS = new Json[16];
    private final MqttClient _mqttClient;

    public DigitalInputs(MqttClient mqttClient) {
        this._mqttClient = mqttClient;
        for (int i = 0; i < 16; ++i) {
            DigitalInputs.JSONS[i] = new Json();
        }
    }

    public void reportCurrentStates() {
        int inputStates = JANOS.getInputStates();
        for (int i = 1; i <= UnitConfig.getInputCount(); ++i) {
            try {
                boolean state = 1 == (inputStates & 1);
                long usageMeter = JANOS.getUsageMeter((int)(i - 1));
                int counter = JANOS.getInputCounter((int)(i - 1));
                this.updateJsonForInput(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        try {
            System.out.println("input changed");
            DigitalInputChannelEvent digitalInputEvent = (DigitalInputChannelEvent)ioEvent;
            if (null != this._mqttClient) {
                String digitalInputTopicPrefix = String.format("%sdigital/inputs/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, digitalInputEvent.Channel);
                if (digitalInputEvent.State) {
                    this._mqttClient.publish(String.format("%s/counter", digitalInputTopicPrefix), String.valueOf(digitalInputEvent.Counter).getBytes(), true);
                }
                this.updateJsonForInput(ioEvent.Channel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void registryKeyUpdated(String registryKeyName) {
        block5: {
            try {
                Matcher matcher = REGISTRY_INPUTS_PATTERN.matcher(registryKeyName);
                boolean found = matcher.find();
                if (!found) break block5;
                try {
                    int channel = Integer.parseInt(matcher.group(1));
                    if (registryKeyName.endsWith("$HourMeter")) {
                        String regValue = JANOS.getRegistryString((String)registryKeyName, (String)"");
                        String digitalInputTopicPrefix = String.format("%sdigital/inputs/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, channel);
                        this.updateJsonForInput(channel);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                AppLog.error("error handling registry key update for " + registryKeyName + " in digital inputs", ex);
            }
        }
    }

    private void updateJsonForInput(int channel) {
        try {
            int channelIndex = channel - 1;
            int outputStates = JANOS.getOutputStates();
            boolean state = 1 == (outputStates >> channelIndex & 1);
            JSONS[channelIndex].put("State", (Object)String.valueOf(state));
            long usageMeter = JANOS.getUsageMeter((int)(channelIndex + UnitConfig.getInputCount()));
            JSONS[channelIndex].put("UsageMeter", (Object)String.valueOf((double)usageMeter / 3600000.0));
            int counter = JANOS.getInputCounter((int)(channel - 1));
            JSONS[channelIndex].put("Counter", (Object)String.valueOf(counter));
            String digitalInputTopicPrefix = String.format("%sdigital/inputs/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, channel);
            this._mqttClient.publish(digitalInputTopicPrefix, JSONS[channelIndex].toString().getBytes(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

