/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.logger.SystemOutLog;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;

public class AppLog {
    private static Logger _log = SystemOutLog.getLogger();
    private static Logger _exceptionLog = SystemOutLog.getLogger();
    private static Logger _debugLog = SystemOutLog.getLogger();
    private static boolean _warnSysLog = true;

    public static void setName(String name) {
        _log = FileLog.getHalfBackupLog(new LogOptions(name + ".log"));
        _exceptionLog = FileLog.getHalfBackupLog(new LogOptions(name + "_exception.log"));
        _debugLog = FileLog.getHalfBackupLog(new LogOptions("/temp/" + name + "_debug.log"));
    }

    public Logger getLog() {
        return _log;
    }

    public static void fatal(String line) {
        if (_log != null) {
            _log.fatal(line);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(QuickDateFormat.getDefault().format());
        sb.append(", *** ");
        sb.append(line);
        System.err.println(sb.toString());
        JANOS.syslog((String)("*** " + line), (int)2, (int)1);
    }

    public static void warn(String line) {
        if (_log != null) {
            _log.warn(line);
        }
        AppLog.sendToSyslogServer(" * " + line, 4);
    }

    public static void error(String error) {
        _log.error(error);
        AppLog.sendToSyslogServer(error, 3);
    }

    public static void error(Throwable ex) {
        _log.error(ex.getMessage());
        _exceptionLog.error(ex);
        String syslogMessage = String.format("** %s", ex.toString());
        AppLog.sendToSyslogServer(syslogMessage, 3);
    }

    public static void error(String description, Throwable ex) {
        _log.error(description);
        _exceptionLog.error(description, ex);
        String syslogMessage = String.format("** %s: %s", description, ex.toString());
        AppLog.sendToSyslogServer(syslogMessage, 3);
    }

    private static void sendToSyslogServer(String message, int level) {
        JANOS.syslog((String)message, (int)level, (int)2);
    }

    public static void debug(String line) {
        if (_debugLog != null) {
            _debugLog.debug(line);
        }
        AppLog.sendToSyslogServer("?? " + line, 6);
    }

    public static void info(String line) {
        if (_log != null) {
            _log.info(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static void vital(String line) {
        if (_log != null) {
            _log.vital(line);
        }
        AppLog.sendToSyslogServer("## " + line, 6);
    }

    public static void printf(String format, Object ... args) {
        String line = String.format(format, args);
        AppLog.info(line);
    }
}

