<html>

<head>
    <style>
        html,
        body {
            background: #555;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
            font-size: 14px;
            line-height: 1.4;
        }

        /* This parent can be any width and height */
        .block {
            text-align: center;

            /* May want to do this if there is risk the container may be narrower than the element inside */
            white-space: nowrap;
        }

        /* The ghost, nudged to maintain perfect centering */
        .block:before {
            content: '';
            display: inline-block;
            height: 100%;
            vertical-align: middle;
            margin-right: -0.25em;
            /* Adjusts for spacing */
        }

        /* The element to be centered, can also be of any width and height */
        .centered {
            display: inline-block;
            text-align: initial;
            vertical-align: middle;
        }

        h1,
        h4 {
            font-weight: 500;
            line-height: 1.1;
        }

        h1 {
            font-size: 36px;
            margin: 8px 0;
        }

        h4 {
            font-size: 24px;
            margin: 4px 0;
        }

        .hostname {
            color: white;
            font-weight: normal;
        }

        .unit-info {
            color: #ddd;
            font-weight: normal;
        }

        .icon-bar {
            width: 100%;
            /* Set a specific width */
        }

        .icon-bar a {
            background-color: #5f5f5f;
            display: block;
            margin: 8px 0;
            padding: 8px;
            padding-right: 24px;
            transition: all 0.3s ease;
            color: white;
            font-size: 18px;
            text-decoration: none;
        }

        .icon-bar a:hover {
            background-color: #c00;
            /* Add a hover color */
        }

        .active {
            background-color: #4CAF50;
            /* Add an active/current color */
        }
    </style>
</head>


<body>

    <div class="block" style="height: 100%;">

        <table class="centered">
            <tr>
                <td style="vertical-align: top; padding-right: 48px;">
                    <h1 class="hostname"><?php=getRegistryString("ipconfig/hostname")?></h1>
                    <h4 class="unit-info">Ser #<?php=getRegistryString("\$serialnumber")?></h4>
                    <h4 class="unit-info">Model <?php=getRegistryString("\$model")?></h4>
                    <h4 class="unit-info">JANOS <?php=getRegistryString("\$version")?></h4>
                    <h4 class="unit-info" style="font-size: smaller;">Last Boot: <?php=getRegistryString("\$boottime")?></h4>
                </td>

                <td style="vertical-align: top;">
                    <div class="icon-bar">
                        <h4><a href="/">DCP - Dynamic Configuration Page</a></h4>
                        <h4><a href="/linesideprinting">Line Side Printing 4.0</a></h4>
                        <h4><a href="#">Grapher</a></h4>
                        <h4><a href="#">MQTT</a></h4>
                        <h4><a href="#">Slave Service 1.5</a></h4>
                        <h4><a href="#">Tasker</a></h4>
                    </div>
                </td>
            </tr>
        </table>

    </div>

</body>

</html>