/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.common.externalmodules.FourTwentyModule;
import com.integ.common.logging.AppLog;
import com.integ.common.logging.Logger;
import com.integ.common.logging.RollingFileLog;
import com.integ.common.system.Application;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.SubscriptionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FourTwentyOutputs
implements SubscriptionListener {
    protected static final Logger SUBSCRIPTION_LOG = RollingFileLog.getLogger(Application.getAppName() + "_subscriptionupdates.log");
    private static final Pattern OUTPUTS_PATTERN = Pattern.compile("jnior/([\\d\\w-]+)/set/fourtwenty/outputs/([\\d\\w-]+)/.*");
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile(".*/percentage");
    private final MqttClient _mqttClient;
    private final FourTwentyModule _fourTwentyModule;

    public FourTwentyOutputs(MqttClient mqttClient, FourTwentyModule fourTwentyModule) {
        this._mqttClient = mqttClient;
        this._mqttClient.addSubscriptionListener(this);
        this._fourTwentyModule = fourTwentyModule;
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._fourTwentyModule && this._fourTwentyModule.isPresent()) {
                this._fourTwentyModule.update();
                int index = this._fourTwentyModule.DeviceIndex - 1;
                for (int channel = 1; channel <= 2; ++channel) {
                    String channelTopic = MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/outputs/" + (index * 2 + channel);
                    this._mqttClient.publish(channelTopic + "/raw", String.valueOf(this._fourTwentyModule.getRawOut(channel - 1)).getBytes(), true);
                    this._mqttClient.publish(channelTopic + "/percentage", String.format("%.2f %%", this._fourTwentyModule.getPercentageOut(channel - 1) * 100.0).getBytes(), true);
                    this._mqttClient.publish(channelTopic + "/scaled", String.format("%.2f %s", this._fourTwentyModule.getScaledOutput(channel - 1), this._fourTwentyModule.getOutputUnits(channel)).getBytes(), true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean subscriptionUpdate(String topic, byte[] data) {
        String topicValue = new String(data);
        SUBSCRIPTION_LOG.info(topic + ": " + topicValue);
        System.out.println("match " + OUTPUTS_PATTERN.pattern() + ", " + topic);
        Matcher matcher = OUTPUTS_PATTERN.matcher(topic);
        boolean found = matcher.find();
        System.out.println(OUTPUTS_PATTERN.pattern() + " matched: " + found);
        if (found) {
            String outputString = matcher.group(2);
            if (!FourTwentyOutputs.isNumeric(outputString)) {
                throw new RuntimeException("error getting channel from " + topic);
            }
            int channel = Integer.parseInt(outputString);
            System.out.println(String.format("channel: 0x%d", channel));
            matcher = PERCENTAGE_PATTERN.matcher(topic);
            found = matcher.find();
            System.out.println(PERCENTAGE_PATTERN.pattern() + " matched: " + found);
            if (found) {
                try {
                    double percentage = Double.valueOf(topicValue);
                    if (0.0 > percentage || 100.0 < percentage) {
                        throw new RuntimeException("Percentage out of range for " + topic + ": " + percentage);
                    }
                    this._fourTwentyModule.setPercentageOutput(channel - 1, percentage);
                    this._fourTwentyModule.commit();
                    this.report();
                }
                catch (Exception ex) {
                    AppLog.error("error converting " + topicValue + " to a percentage", ex);
                }
            }
        }
        return false;
    }

    private static boolean isNumeric(String s) {
        boolean isNumeric = true;
        for (int j = 0; isNumeric && j < s.length(); isNumeric &= Character.isDigit(s.charAt(j)), ++j) {
        }
        return isNumeric;
    }
}

