/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.logging;

import com.integ.common.logging.Logger;
import com.integ.common.logging.RollingFileLog;
import com.integ.common.system.Application;
import com.integ.common.utils.ExceptionUtils;
import com.integpg.system.JANOS;
import java.text.QuickDateFormat;

public class AppLog {
    private static QuickDateFormat DateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss zzz");
    private static Logger _log;
    private static Logger _exceptionLog;

    private static synchronized void ensureLogFile() {
        try {
            String appName = Application.getAppInstanceName();
            if (_log == null && appName != null) {
                _log = RollingFileLog.getLogger(appName);
            }
            if (_exceptionLog == null && appName != null) {
                _exceptionLog = RollingFileLog.getLogger(appName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append(DateFormat.format(System.currentTimeMillis()));
            sb.append(", ");
            sb.append(ex.toString());
            System.err.println(sb.toString());
        }
    }

    public static void setDateFormat(String dateFormat) {
        if (!dateFormat.equals(DateFormat.getDateFormatString())) {
            AppLog.info("Change applog date format to " + dateFormat);
            DateFormat = new QuickDateFormat(dateFormat);
        }
    }

    public static Logger getLog() {
        return _log;
    }

    public static void setAppLog(Logger log) {
        _log = log;
    }

    public static void setAppExceptionLog(Logger log) {
        _exceptionLog = log;
    }

    public static void fatal(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.fatal(line);
        }
        JANOS.syslog((String)line, (int)2, (int)1);
    }

    public static void warn(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.warn(line);
        }
        AppLog.sendToSyslogServer(line, 4);
    }

    public static void error(String error) {
        AppLog.ensureLogFile();
        _log.error(error);
        AppLog.sendToSyslogServer(error, 3);
    }

    public static void error(Throwable ex) {
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        AppLog.ensureLogFile();
        _log.error(ex.getMessage());
        if (_exceptionLog != null) {
            _exceptionLog.error(stackTrace);
        } else {
            ex.printStackTrace(System.out);
        }
        AppLog.sendToSyslogServer(ex.toString(), 3);
    }

    public static void error(String description, Throwable ex) {
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        AppLog.ensureLogFile();
        _log.error(description + ":" + ex.getMessage());
        if (_exceptionLog != null) {
            _exceptionLog.error(description + ": " + stackTrace);
        } else {
            ex.printStackTrace(System.out);
        }
        AppLog.sendToSyslogServer(description + ": " + ex.toString(), 3);
    }

    private static void sendToSyslogServer(String message, int level) {
        JANOS.syslog((String)message, (int)level, (int)2);
    }

    public static void debug(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.debug(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static void info(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.info(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static void vital(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.vital(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }
}

