/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.utils;

import com.integpg.system.JANOS;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllBytes(String filename, byte[] bytes) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            fos.write(bytes);
            fos.flush();
        }
        catch (Exception ex) {
            JANOS.syslog((String)("writeAllBytes to " + filename + " threw " + ex.getMessage()), (int)3);
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAllBytes(String filename, byte[] bytes) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename, true);
            fos.write(bytes);
            fos.flush();
        }
        catch (Exception ex) {
            JANOS.syslog((String)("appendAllBytes to " + filename + " threw " + ex.getMessage()), (int)3);
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendBytes(String filename, byte[] bytes, int offset, int length) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename, true);
            fos.write(bytes, offset, length);
            fos.flush();
        }
        catch (Exception ex) {
            JANOS.syslog((String)("appendAllBytes to " + filename + " threw " + ex.getMessage()), (int)3);
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(String filename) throws IOException {
        File file = new File(filename);
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream fis = new FileInputStream(file.getPath());
        try (DataInputStream dis = new DataInputStream(fis);){
            dis.readFully(bytes);
        }
        return bytes;
    }

    public static String readAllText(String filename) throws IOException {
        byte[] fileBytes = FileUtils.readAllBytes(filename);
        String fileContent = new String(fileBytes);
        return fileContent;
    }

    public static void copyfile(File srcFile, int srPos, File dstFile, int dtPos) {
        try {
            int len;
            long start = System.currentTimeMillis();
            RandomAccessFile in = new RandomAccessFile(srcFile, "r");
            in.seek(srPos);
            RandomAccessFile out = new RandomAccessFile(dstFile, "rw");
            out.seek(dtPos);
            byte[] buf = new byte[16384];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("took " + elapsed + " to copy " + srcFile.getAbsolutePath() + " to " + dstFile.getAbsolutePath());
        }
        catch (Exception ex) {
            System.err.println("Error copying file " + srcFile.getPath() + " to " + dstFile.getPath() + ": " + ex.toString());
        }
    }
}

