/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.mqtt.AssemblyInfo;
import com.integ.mqtt.Config;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.SubscriptionListener;
import com.integ.registry.RegistryListener;
import com.integpg.janoslib.iolog.DigitalOutputChannelEvent;
import com.integpg.janoslib.iolog.IoChannelEvent;
import com.integpg.janoslib.iolog.IoChannelLogListener;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.Iolog;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Json;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelayOutputs
implements IoChannelLogListener,
SubscriptionListener,
RegistryListener {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss.SSS");
    private static final Iolog IOLOG = new Iolog();
    protected static final Logger SUBSCRIPTION_LOG = Logger.getLogger(AssemblyInfo.getInstance().getName() + "_subscriptionupdates.log");
    private static final Pattern OUTPUTS_PATTERN = Pattern.compile("jnior/([\\d\\w-]+)/set/digital/outputs/([\\d\\w-]+)/.*");
    private static final Pattern STATE_PATTERN = Pattern.compile(".*/state");
    private static final Pattern REGISTRY_OUTPUTS_PATTERN = Pattern.compile("io/outputs/rout(\\d+)/.*", 1);
    private static final Json[] JSONS = new Json[16];
    private final MqttClient _mqttClient;

    public RelayOutputs(MqttClient mqttClient) {
        this._mqttClient = mqttClient;
        this._mqttClient.addSubscriptionListener(this);
        for (int i = 0; i < 16; ++i) {
            RelayOutputs.JSONS[i] = new Json();
        }
    }

    public void reportCurrentStates() {
        int outputCount = UnitConfig.getOutputCount();
        int outputStates = JANOS.getOutputStates();
        for (int i = 1; i <= outputCount; ++i) {
            try {
                int payloadFormat = Config.getPayloadFormat();
                if (1 == payloadFormat || 3 == payloadFormat) {
                    boolean state = 1 == (outputStates >> i - 1 & 1);
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + i + "/state", String.valueOf(state).getBytes(), true);
                    long usageMeter = JANOS.getUsageMeter((int)(i - 1 + UnitConfig.getInputCount()));
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + i + "/usagemeter", String.valueOf((double)usageMeter / 3600000.0).getBytes(), true);
                }
                if (2 != payloadFormat && 3 != payloadFormat) continue;
                this.updateJsonForOutput(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        try {
            System.out.println("output changed");
            DigitalOutputChannelEvent digitalOutputEvent = (DigitalOutputChannelEvent)ioEvent;
            int payloadFormat = Config.getPayloadFormat();
            if (1 == payloadFormat || 3 == payloadFormat) {
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + digitalOutputEvent.Channel + "/state", String.valueOf(digitalOutputEvent.State).getBytes(), true);
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + digitalOutputEvent.Channel + "/usagemeter", String.valueOf((double)digitalOutputEvent.UsageMeter / 3600000.0).getBytes(), true);
            }
            if (2 == payloadFormat || 3 == payloadFormat) {
                this.updateJsonForOutput(digitalOutputEvent.Channel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isNumeric(String s) {
        boolean isNumeric = true;
        for (int j = 0; isNumeric && j < s.length(); isNumeric &= Character.isDigit(s.charAt(j)), ++j) {
        }
        return isNumeric;
    }

    @Override
    public boolean subscriptionUpdate(String topic, byte[] data) {
        String topicValue = new String(data);
        SUBSCRIPTION_LOG.info(topic + ": " + topicValue);
        Matcher matcher = OUTPUTS_PATTERN.matcher(topic);
        boolean found = matcher.find();
        if (found) {
            int channelMask = 0;
            String outputString = matcher.group(2);
            if (RelayOutputs.isNumeric(outputString)) {
                int channel = Integer.parseInt(outputString);
                channelMask = 1 << channel - 1;
            } else {
                channelMask = Config.getOutputMask(outputString);
            }
            System.out.println(String.format("channelMask: 0x%d", channelMask));
            int statesMask = channelMask;
            matcher = STATE_PATTERN.matcher(topic);
            found = matcher.find();
            if (found) {
                boolean newState;
                String[] parts = StringUtils.split(topicValue, " ");
                System.out.println("parts.length: " + parts.length);
                String newStateString = parts[0];
                boolean bl = newState = null != newStateString && ("true".equalsIgnoreCase(newStateString) || "high".equalsIgnoreCase(newStateString) || "on".equalsIgnoreCase(newStateString) || "set".equalsIgnoreCase(newStateString) || "1".equalsIgnoreCase(newStateString));
                if (!newState) {
                    statesMask ^= 0xFFF;
                }
                System.out.println(String.format("set channelMask to 0x%d", statesMask &= channelMask));
                if (1 < parts.length) {
                    try {
                        double duration = Double.valueOf(parts[1].trim());
                        JANOS.setOutputPulsed((int)statesMask, (int)channelMask, (int)((int)(duration * 1000.0)));
                        return true;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    try {
                        System.out.println(String.format("set 0x%d to 0x%d", channelMask, statesMask));
                        JANOS.setOutputStates((int)statesMask, (int)channelMask);
                        return true;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void registryKeyUpdated(String registryKeyName) {
        block7: {
            try {
                Matcher matcher = REGISTRY_OUTPUTS_PATTERN.matcher(registryKeyName);
                boolean found = matcher.find();
                if (!found) break block7;
                try {
                    int channel = Integer.parseInt(matcher.group(1));
                    if (registryKeyName.endsWith("$HourMeter")) {
                        String regValue = JANOS.getRegistryString((String)registryKeyName, (String)"");
                        int payloadFormat = Config.getPayloadFormat();
                        if (1 == payloadFormat || 3 == payloadFormat) {
                            String digitalOutputTopicPrefix = String.format("%sdigital/outputs/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, channel);
                            this._mqttClient.publish(String.format("%s/usagemeter", digitalOutputTopicPrefix), regValue.getBytes());
                        }
                        if (2 == payloadFormat || 3 == payloadFormat) {
                            this.updateJsonForOutput(channel);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                AppLog.error("error handling registry key update for " + registryKeyName + " in digital outputs", ex);
            }
        }
    }

    private void updateJsonForOutput(int channel) {
        try {
            int channelIndex = channel - 1;
            int outputStates = JANOS.getOutputStates();
            boolean state = 1 == (outputStates >> channelIndex & 1);
            JSONS[channelIndex].put("State", (Object)String.valueOf(state));
            long usageMeter = JANOS.getUsageMeter((int)(channelIndex + UnitConfig.getInputCount()));
            JSONS[channelIndex].put("UsageMeter", (Object)String.format("%.2f", (double)usageMeter / 3600000.0));
            IOLOG.refresh();
            if (state) {
                long[] lastHightime = IOLOG.getOutputTransitions(channelIndex, 1, 1);
                if (0 < lastHightime.length) {
                    JSONS[channelIndex].put("TransitionTimestamp", lastHightime[0]);
                    JSONS[channelIndex].put("TransitionTime", (Object)DATE_FORMAT.format(lastHightime[0]));
                }
            } else {
                long[] lastLowtime = IOLOG.getOutputTransitions(channelIndex, 0, 1);
                if (0 < lastLowtime.length) {
                    JSONS[channelIndex].put("TransitionTimestamp", lastLowtime[0]);
                    JSONS[channelIndex].put("TransitionTime", (Object)DATE_FORMAT.format(lastLowtime[0]));
                }
            }
            String digitalOutputTopicPrefix = String.format("%sdigital/outputs/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, channel);
            this._mqttClient.publish(digitalOutputTopicPrefix, JSONS[channelIndex].toString().getBytes(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

