/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integpg.janoslib.externalio.TypeFE;

public class MqttFourTwentyInputs {
    private final MqttClient _mqttClient;
    private final TypeFE _fourTwentyModule;

    public MqttFourTwentyInputs(MqttClient mqttClient, TypeFE fourTwentyModule) {
        this._mqttClient = mqttClient;
        this._fourTwentyModule = fourTwentyModule;
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._fourTwentyModule && this._fourTwentyModule.isPresent()) {
                this._fourTwentyModule.read();
                if (this._fourTwentyModule.hasChanged()) {
                    System.out.println(String.format("typeIndex: %d", this._fourTwentyModule.TypeIndex));
                    int index = this._fourTwentyModule.TypeIndex - 1;
                    for (int channel = 1; channel <= 4; ++channel) {
                        this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/inputs/" + (index * 4 + channel) + "/raw", String.valueOf(this._fourTwentyModule.getRawIn(channel)).getBytes(), true);
                        this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/inputs/" + (index * 4 + channel) + "/percentage", String.valueOf(this._fourTwentyModule.getPercentageInput(channel)).getBytes(), true);
                        this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/inputs/" + (index * 4 + channel) + "/scaled", String.format("%.2f %s", this._fourTwentyModule.getScaledInput(channel), this._fourTwentyModule.getInputUnits(channel)).getBytes(), true);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

