/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.logging;

import com.integ.common.logging.FileLog;
import com.integ.common.logging.LogOutputStream;
import com.integ.common.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;

public class HalfBakLogOutputStream
extends LogOutputStream {
    public HalfBakLogOutputStream(String filename) throws FileNotFoundException {
        super(filename);
    }

    @Override
    protected int preWrite(byte[] b, int off, int len) throws IOException {
        return 0;
    }

    @Override
    protected void postWrite(int len) throws IOException {
        if ((long)this._maxFileSize < this._file.length()) {
            this.halfBakFile();
        }
    }

    private void halfBakFile() throws IOException {
        long start = System.currentTimeMillis();
        System.out.println(this._file.getName() + " file size: " + this._file.length());
        int halfSize = this._maxFileSize / 2;
        byte[] firstHalf = FileUtils.readBytes(this._file.getPath(), 0, halfSize);
        Date lastEntryDate = null;
        for (int i = firstHalf.length - 1; i >= 0; --i) {
            if (10 != firstHalf[i]) continue;
            halfSize = i;
            System.out.println(this._file.getName() + " half size: " + halfSize);
            int lastComma = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (44 == firstHalf[j]) {
                    lastComma = j;
                    continue;
                }
                if (10 != firstHalf[j] || -1 == lastComma) continue;
                String dateString = new String(firstHalf, ++j, lastComma - j);
                System.out.println(this._file.getName() + " HALF BAK dateString: " + dateString);
                try {
                    lastEntryDate = FileLog.LogDateFormat.parse(dateString);
                }
                catch (Exception ex) {
                    System.out.println(this._file.getName() + " ERROR PARSING HALF BAK DATE");
                    lastComma = -1;
                }
                break;
            }
            if (null != lastEntryDate) break;
        }
        if (null == lastEntryDate) {
            System.out.println(this._file.getName() + " HALF BAK DATE NOT FOUND");
            lastEntryDate = new Date();
        }
        this._file.renameTo(this._tmpFile);
        File bakFile = new File(this._file.getPath() + ".bak");
        if (bakFile.exists()) {
            bakFile.delete();
        }
        FileUtils.writeBytes(this._bakFile.getPath(), firstHalf, 0, halfSize);
        this._bakFile.setLastModified(lastEntryDate.getTime());
        FileUtils.copyfile(this._tmpFile, halfSize, this._file, 0);
        this._tmpFile.delete();
        long elapsed = System.currentTimeMillis() - start;
        System.out.println(String.format("took %lld to create half bak file for %s", elapsed, this._file.getPath()));
    }
}

