/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.mqtt.AssemblyInfo;
import com.integ.mqtt.Config;
import com.integ.mqtt.ConfigurationListener;
import com.integ.mqtt.DigitalInputs;
import com.integ.mqtt.MqttSystemMessage;
import com.integ.mqtt.RelayOutputs;
import com.integ.mqtt.externalmodules.MqttEnvironSensor;
import com.integ.mqtt.externalmodules.MqttFourTwentyInputs;
import com.integ.mqtt.externalmodules.MqttFourTwentyOutputs;
import com.integ.mqtt.externalmodules.MqttTempProbe;
import com.integ.mqtt.externalmodules.MqttTenVoltInputs;
import com.integ.mqtt.externalmodules.MqttTenVoltOutputs;
import com.integ.mqtt.listeners.ConnectionAcceptedEventObject;
import com.integ.mqtt.listeners.MqttClientListener;
import com.integ.mqtt.listeners.SubscriptionListener;
import com.integ.mqtt.listeners.UnhandledSubscriptionListener;
import com.integ.mqtt.messagehandlers.ConfigUpdatedEventHandler;
import com.integ.mqtt.messagehandlers.ConnectEventHandler;
import com.integ.mqtt.messagehandlers.DisconnectEventHandler;
import com.integ.mqtt.messagehandlers.GetStatusEventHandler;
import com.integ.mqtt.messagehandlers.PublishEventHandler;
import com.integ.mqtt.protocol.ConnectOptions;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.incomingpackets.ConnAckPacket;
import com.integ.mqtt.protocol.incomingpackets.ConnAckReturnCodes;
import com.integ.mqtt.protocol.outgoingpackets.SubscribeOptions;
import com.integ.mqtt.protocol.outgoingpackets.SubscribeTopic;
import com.integ.mqtt.protocol.outgoingpackets.UnsubscribeOptions;
import com.integ.registry.RegistryListener;
import com.integ.registry.RegistryUpdateHandler;
import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.Type28;
import com.integpg.janoslib.externalio.Type7E;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.externalmodules.PresentDevices;
import com.integpg.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integpg.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.messagepump.MessagePumpAppHandler;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.net.BytesReceivedEvent;
import com.integpg.janoslib.system.JanosApplication;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;

public class MqttMain
extends JanosApplication
implements MqttClientListener,
SubscriptionListener,
UnhandledSubscriptionListener,
RegistryListener,
ConfigurationListener {
    private static final MqttMain MAIN = new MqttMain();
    private static final Logger UNHANDLED_SUBSCRIPTION_LOGGER = Logger.getLogger(AssemblyInfo.getInstance().getName() + "_unhandledsubscriptions.log");
    public static final File FLASH_MQTT = new File("/flash/mqtt/");
    public static final String DEVICE_STATUS_TOPIC_PREFIX = "jnior/" + JANOS.getSerialNumber() + "/status/";
    public static final String DEVICE_SET_TOPIC_PREFIX = "jnior/" + JANOS.getSerialNumber() + "/set/";
    public static final QuickDateFormat CONNECTION_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss");
    public MqttClient _mqttClient = null;
    private String _savedHostname;
    private RelayOutputs _relayOutputs;
    private DigitalInputs _digitalInputs;
    private boolean _successfullyConnected;
    private final Hashtable<String, ExternalModule> _modulesByAddress = new Hashtable();
    private final ArrayList<MqttFourTwentyInputs> _fourTwentyInputs = new ArrayList();
    private final ArrayList<MqttFourTwentyOutputs> _fourTwentyOutputs = new ArrayList();
    private final ArrayList<MqttTenVoltInputs> _tenVoltInputs = new ArrayList();
    private final ArrayList<MqttTenVoltOutputs> _tenVoltOutputs = new ArrayList();
    private final ArrayList<MqttTempProbe> _tempProbes = new ArrayList();
    private final ArrayList<MqttEnvironSensor> _environSensors = new ArrayList();
    private boolean _force;
    private final ArrayList<String> _savedDeviceGroups = new ArrayList();

    public static void main(String[] args) throws InterruptedException {
        MqttMain.exec(MAIN, AssemblyInfo.getInstance(), args);
    }

    public static MqttMain getInstance() {
        return MAIN;
    }

    @Override
    public boolean shouldPreventDuplicateInstance() {
        return true;
    }

    @Override
    public void init(String[] args) {
        if (!FLASH_MQTT.exists()) {
            FLASH_MQTT.mkdir();
        }
        Config.addConfigurationUpdatedListener(this);
        Config.load();
        MessagePumpEngine.start();
        this._mqttClient = new MqttClient();
        this.reportConnectionStatusToWebClients();
        this._digitalInputs = new DigitalInputs(this._mqttClient);
        DigitalInputsIoLogMonitor inputMonitor = new DigitalInputsIoLogMonitor();
        inputMonitor.addIoChannelLogEventListener(this._digitalInputs);
        inputMonitor.start();
        this._relayOutputs = new RelayOutputs(this._mqttClient);
        DigitalOutputsIoLogMonitor outputMonitor = new DigitalOutputsIoLogMonitor();
        outputMonitor.addIoChannelLogEventListener(this._relayOutputs);
        outputMonitor.start();
        RegistryUpdateHandler registryUpdateHandler = new RegistryUpdateHandler();
        registryUpdateHandler.addRegistryListener(this);
        registryUpdateHandler.addRegistryListener(this._digitalInputs);
        registryUpdateHandler.addRegistryListener(this._relayOutputs);
        MessagePumpEngine.addListener(registryUpdateHandler);
        MessagePumpAppHandler mqttAppListener = new MessagePumpAppHandler(1600).addCommandListener("get-status", new GetStatusEventHandler()).addCommandListener("config-updated", new ConfigUpdatedEventHandler()).addCommandListener("connect", new ConnectEventHandler()).addCommandListener("disconnect", new DisconnectEventHandler()).addCommandListener("publish", new PublishEventHandler()).addCommandListener("subscribe", new PublishEventHandler());
        MessagePumpEngine.addListener(mqttAppListener);
        this._mqttClient.getClientNotifier().add(this);
        this._mqttClient.getSubscriptionNotifier().add(this);
        this._mqttClient.getUnhandledSubscriptionNotifier().add(this);
        this._mqttClient.start();
    }

    @Override
    public boolean subscriptionUpdate(String topic, byte[] data) {
        if (topic.endsWith("set-hostname")) {
            String message = new String(data);
            AppLog.info("setting hostname to " + message);
            JANOS.setRegistryString((String)"IpConfig/Hostname", (String)message);
            return true;
        }
        return false;
    }

    @Override
    public void connectionAttempt(EventObject evt) {
        String host = Config.getBrokerHost();
        if (null == host || "".equals(host)) {
            return;
        }
        int port = Config.getBrokerPort();
        boolean secure = Config.getEncrypted();
        System.out.println(String.format("connect to %s:%d, secure: %s", host, port, String.valueOf(secure)));
        if (!"".equalsIgnoreCase(host)) {
            String lastWillMessage;
            this._mqttClient.setHost(host).setPort(port).setSecure(secure);
            String lastWillTopic = Config.getLastWillTopic();
            if (null == lastWillTopic || "".equals(lastWillTopic)) {
                lastWillTopic = "jnior/" + JANOS.getSerialNumber() + "/LastWill";
            }
            if (null == (lastWillMessage = Config.getLastWillMessage()) || "".equals(lastWillMessage)) {
                lastWillMessage = "Has disconnected";
            }
            ConnectOptions connectOptions = new ConnectOptions("jr" + JANOS.getSerialNumber());
            connectOptions.setCleanConnection(true).setUsername(Config.getUsername()).setPassword(Config.getPassword()).setKeepAliveSeconds(900).setWillTopic(lastWillTopic).setWillMessage(lastWillMessage).setWillQos(0).setWillRetain(Boolean.FALSE);
            this._mqttClient.setConnectOptions(connectOptions);
        }
    }

    @Override
    public void connectionEstablished(EventObject evt) {
        AppLog.info("Connected to mqtt broker: " + this._mqttClient.getConnectionInfo());
        JANOS.setRegistryString((String)"AppData/MQTT/ConnectionEstablishedTime", (String)CONNECTION_DATE_FORMAT.format(System.currentTimeMillis()));
        this.reportConnectionStatusToWebClients();
        this._successfullyConnected = true;
    }

    @Override
    public void connectionAccepted(ConnectionAcceptedEventObject evt) {
        ConnAckPacket connAckPacket = evt.getConnAckPacket();
        if (null != connAckPacket) {
            ConnAckReturnCodes returnCode = connAckPacket.getReturnCode();
            this.reportConnectionStatusToWebClients();
            if (returnCode == ConnAckReturnCodes.CONNECTION_ACCEPTED) {
                long start = System.currentTimeMillis();
                try {
                    String hostname;
                    this._savedHostname = hostname = UnitConfig.getHostname();
                    String lowercaseHostname = hostname.toLowerCase();
                    this._mqttClient.publish(DEVICE_STATUS_TOPIC_PREFIX + "connection_time", CONNECTION_DATE_FORMAT.format(System.currentTimeMillis()).getBytes(), true);
                    this._mqttClient.publish(DEVICE_STATUS_TOPIC_PREFIX + "hostname", hostname.getBytes(), true);
                    SubscribeOptions subscribeOptions = new SubscribeOptions().addTopic(new SubscribeTopic("jnior/" + UnitConfig.SERIAL_NUMBER + "/set/#", 1)).addTopic(new SubscribeTopic("jnior/" + lowercaseHostname + "/set/#", 1)).addTopic(new SubscribeTopic("jnior/" + UnitConfig.SERIAL_NUMBER + "/custom/#", 1)).addTopic(new SubscribeTopic("jnior/" + lowercaseHostname + "/custom/#", 1));
                    this._mqttClient.subscribe(subscribeOptions);
                    this.updateDeviceNameSubscription();
                    this._force = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    AppLog.error("error in connection acknowledged", ex);
                }
                this._digitalInputs.reportCurrentStates();
                this._relayOutputs.reportCurrentStates();
                long elapsed = System.currentTimeMillis() - start;
                AppLog.info(String.format("Initial IO reported in %.2f seconds", (double)elapsed / 1000.0));
            }
        }
    }

    @Override
    public void connectionClosed(EventObject evt) {
        System.out.println("connection closed");
        JANOS.setRegistryString((String)"AppData/MQTT/ConnectionLostTime", (String)CONNECTION_DATE_FORMAT.format(System.currentTimeMillis()));
        this.reportConnectionStatusToWebClients();
    }

    @Override
    public void bytesReceived(BytesReceivedEvent evt) {
    }

    @Override
    public void registryKeyUpdated(String registryKeyName) {
        if ("ipconfig/hostname".equalsIgnoreCase(registryKeyName)) {
            try {
                String hostname = UnitConfig.getHostname();
                AppLog.info("old hostname: " + this._savedHostname);
                UnsubscribeOptions unsubscribeOptions = new UnsubscribeOptions().addTopic("jnior/" + this._savedHostname.toLowerCase() + "/set/#").addTopic("jnior/" + this._savedHostname.toLowerCase() + "/custom/#");
                this._mqttClient.unsubscribe(unsubscribeOptions);
                AppLog.info("new hostname: " + UnitConfig.getHostname());
                SubscribeOptions subscribeOptions = new SubscribeOptions().addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/set/#", 1)).addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/custom/#", 1));
                this._mqttClient.subscribe(subscribeOptions);
                this._mqttClient.publish(DEVICE_STATUS_TOPIC_PREFIX + "hostname", hostname.getBytes(), true);
                this._savedHostname = hostname;
            }
            catch (Exception ex) {
                AppLog.error("error handling registry key update for " + registryKeyName + " in MqttMain", ex);
            }
        }
    }

    @Override
    public void configurationUpdated() {
        try {
            if (null != this._mqttClient && !Config.getBrokerHost().equalsIgnoreCase(this._mqttClient.getHost())) {
                this._mqttClient.close();
            }
            this.updateDeviceNameSubscription();
        }
        catch (Exception ex) {
            AppLog.error("error in configuration listener", ex);
        }
    }

    @Override
    public void unhandledSubscriptionUpdate(String topic, byte[] data) {
        try {
            UNHANDLED_SUBSCRIPTION_LOGGER.info("topic " + topic + " has not been handled");
            String message = new String(data);
            MqttSystemMessage msg = new MqttSystemMessage("unhandled-topic").put("Topic", topic).put("Payload", message);
            MessagePumpEngine.postMessage(msg.getSystemMsg());
        }
        catch (Exception ex) {
            AppLog.error("error in unhandled subscription handler", ex);
        }
    }

    @Override
    public void run() throws InterruptedException {
        this._mqttClient.connect();
        while (true) {
            Thread.sleep(10000L);
            super.feedWatchdog();
            try {
                this.checkForNewDevices();
                if (this._mqttClient.isConnectionAccepted()) {
                    for (MqttFourTwentyInputs fourTwentyInputs : this._fourTwentyInputs) {
                        fourTwentyInputs.report(this._force);
                    }
                    for (MqttFourTwentyOutputs fourTwentyOutputs : this._fourTwentyOutputs) {
                        fourTwentyOutputs.report(this._force);
                    }
                    for (MqttTenVoltInputs tenVoltInputs : this._tenVoltInputs) {
                        tenVoltInputs.report(this._force);
                    }
                    for (MqttTenVoltOutputs tenVoltOutputs : this._tenVoltOutputs) {
                        tenVoltOutputs.report(this._force);
                    }
                    for (MqttTempProbe tempProbes : this._tempProbes) {
                        tempProbes.report(this._force);
                    }
                    for (MqttEnvironSensor environSensor : this._environSensors) {
                        environSensor.report(this._force);
                    }
                    this._force = false;
                }
            }
            catch (Throwable ex) {
                AppLog.error("error in mqtt main loop", ex);
            }
            Thread.sleep(5000L);
        }
    }

    private void updateDeviceNameSubscription() throws Exception {
        try {
            if (null != this._mqttClient) {
                String[] mqttGroups = Config.getDeviceGroups();
                if (0 < this._savedDeviceGroups.size()) {
                    UnsubscribeOptions unsubscribeOptions = new UnsubscribeOptions();
                    for (String savedMqttGroup : this._savedDeviceGroups) {
                        String topicName = "jnior/" + savedMqttGroup.toLowerCase() + "/set/#";
                        AppLog.info("unsubscribe from " + topicName);
                        unsubscribeOptions.addTopic(topicName);
                        topicName = "jnior/" + savedMqttGroup.toLowerCase() + "/custom/#";
                        AppLog.info("unsubscribe from " + topicName);
                        unsubscribeOptions.addTopic(topicName);
                    }
                    this._mqttClient.unsubscribe(unsubscribeOptions);
                }
                if (0 < mqttGroups.length) {
                    SubscribeOptions subscribeOptions = new SubscribeOptions();
                    for (String mqttGroup : mqttGroups) {
                        String topicName = "jnior/" + mqttGroup.toLowerCase() + "/set/#";
                        AppLog.info("subscribe to " + topicName);
                        subscribeOptions.addTopic(new SubscribeTopic(topicName, 1));
                        topicName = "jnior/" + mqttGroup.toLowerCase() + "/custom/#";
                        AppLog.info("subscribe to " + topicName);
                        subscribeOptions.addTopic(new SubscribeTopic(topicName, 1));
                    }
                    this._mqttClient.subscribe(subscribeOptions);
                }
                this._savedDeviceGroups.clear();
                for (String mqttGroup : mqttGroups) {
                    this._savedDeviceGroups.add(mqttGroup);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("error in device name subscription handler", ex);
        }
    }

    public void reportConnectionStatusToWebClients() {
        MqttSystemMessage msg = new MqttSystemMessage("current-status").put("ConnectionStatus", this._mqttClient.isConnectionAccepted()).put("ConnectionInfo", this._mqttClient.getConnectionInfo());
        System.out.println(String.format("ConnectionStatus: %s", msg.getJson().toString()));
        MessagePumpEngine.postMessage(msg.getSystemMsg());
    }

    private void checkForNewDevices() {
        String[] presentDeviceAddressStringArray;
        String presentDeviceAddressStrings = PresentDevices.getPresentDevicesString();
        for (String presentDeviceAddressString : presentDeviceAddressStringArray = StringUtils.split(presentDeviceAddressStrings, ",")) {
            if (this._modulesByAddress.containsKey(presentDeviceAddressString)) continue;
            try {
                System.out.println("new module: " + presentDeviceAddressString);
                int type = ExternalUtils.getTypeForAddressString(presentDeviceAddressString);
                System.out.println("type = " + type);
                int index = ExternalUtils.getIndexForAddress(presentDeviceAddressString);
                System.out.println("index = " + index);
                switch (type) {
                    case 40: {
                        Type28 tempProbeDevice = Type28.getByIndex(index);
                        System.out.println(String.format("temp probe: %s", tempProbeDevice.AddressString));
                        this._tempProbes.add(new MqttTempProbe(this._mqttClient, tempProbeDevice));
                        this._modulesByAddress.put(presentDeviceAddressString, tempProbeDevice);
                        break;
                    }
                    case 126: {
                        Type7E environSensorDevice = Type7E.getByIndex(index);
                        System.out.println(String.format("environ sensor: %s", environSensorDevice.AddressString));
                        this._environSensors.add(new MqttEnvironSensor(this._mqttClient, environSensorDevice));
                        this._modulesByAddress.put(presentDeviceAddressString, environSensorDevice);
                        break;
                    }
                    case 253: {
                        TypeFD tenVoltModule = TypeFD.getByIndex(index);
                        System.out.println(String.format("ten volt module: %s", tenVoltModule.AddressString));
                        this._tenVoltInputs.add(new MqttTenVoltInputs(this._mqttClient, tenVoltModule));
                        this._tenVoltOutputs.add(new MqttTenVoltOutputs(this._mqttClient, tenVoltModule));
                        this._modulesByAddress.put(presentDeviceAddressString, tenVoltModule);
                        break;
                    }
                    case 254: {
                        TypeFE fourTwentyModule = TypeFE.getByIndex(index);
                        System.out.println(String.format("four twenty module: %s", fourTwentyModule.AddressString));
                        this._fourTwentyInputs.add(new MqttFourTwentyInputs(this._mqttClient, fourTwentyModule));
                        this._fourTwentyOutputs.add(new MqttFourTwentyOutputs(this._mqttClient, fourTwentyModule));
                        this._modulesByAddress.put(presentDeviceAddressString, fourTwentyModule);
                    }
                }
            }
            catch (IOException ex) {
                AppLog.error(ex);
            }
        }
    }
}

