/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.protocol.outgoingpackets;

import com.integ.mqtt.protocol.QualityOfService;
import com.integ.mqtt.protocol.outgoingpackets.MqttOutgoingPacket;
import com.integpg.janoslib.utils.HexUtils;
import java.io.IOException;

public class PublishPacket
extends MqttOutgoingPacket {
    private final String _topicName;
    private final byte[] _valueBytes;
    private int _qosLevel = 0;
    private boolean _retain;

    public PublishPacket(String topicName, byte[] valueBytes) {
        this._packetType = 3;
        this._topicName = topicName;
        this._valueBytes = valueBytes;
    }

    public PublishPacket setRetainFlag(boolean retainFlag) {
        this._retain = retainFlag;
        return this;
    }

    public int getQos() {
        return this._qosLevel;
    }

    public PublishPacket setQos(int qosLevel) {
        this._qosLevel = qosLevel;
        return this;
    }

    public String getTopicName() {
        return this._topicName;
    }

    public byte[] getValue() {
        return this._valueBytes;
    }

    @Override
    protected void build() throws IOException {
        if (0 != this._qosLevel) {
            this._flags |= 1 << this._qosLevel;
        }
        if (this._retain) {
            this._flags |= 1;
        }
        this.writeString(this._variableHeader, this._topicName);
        if (0 < this._qosLevel) {
            this._variableHeader.writeShort(this.getPacketIdentifier());
        }
        this._variableHeader.write(this._valueBytes);
    }

    @Override
    public String toString() {
        return String.format("PUBLISH packet, topic: %s = %s, packetId: %d, qos: %s", this._topicName, HexUtils.getString(this._valueBytes), this.getPacketIdentifier(), QualityOfService.getString(this._qosLevel));
    }
}

