App.controller('Controller', function ($scope, $location) {
    var _this = this;
    _this.SerialNumber = '#########';
    _this.Connected = false;
    _this.Config = {};
    _this.SavedConfig = angular.copy(_this.Config);
    _this.Status = { ConnectionStatus: null, ConnectionEstablishedTime: 'Unknown' };
    // _this.UpdateAvailable = false;


    // instantiate our JniorConfigStorage class and pass in our websocket object
    var jniorConfigStorage = new JniorConfigStorage(jnrWebsocket, '/flash/mqtt/config.json');

    // onLoggedIn callback.  this is where we will read the config file
    jnrWebsocket.addOnLoggedInListener(function onLoggedIn() {
        console.log('onLoggedIn');
        _this.readConfig();

        jnrWebsocket.readRegistryKeys(
            ["$serialnumber", "ipconfig/hostname"],
            function (key, value) {
                if (key.endsWith('serialnumber')) _this.SerialNumber = value;
                else if (key.endsWith('hostname')) _this.HostName = value;

                $scope.$apply();
            }
        );

        jnrWebsocket.addEventListener('onMessage', _this.onMessage);
        jnrWebsocket.postMessage(APP_ID, { Message: 'get-status' });

        GetVersionFunc = function () {
            jnrWebsocket.registrySubscription('AppData/MQTT/$version',
                function (key, value) {
                    if (value && '' !== value) {
                        current_version_string = value;
                        current_version = parseVersion(current_version_string);
                        console.log('version: ' + current_version_string + ' ' + JSON.stringify(current_version));

                        var latest_version_string = APP_RELEASES.latest_version.version;
                        latest_version = parseVersion(latest_version_string);
                        console.log('latest_version: ' + latest_version_string + ' ' + JSON.stringify(latest_version));

                        if (latest_version.major > current_version.major || (
                            latest_version.major == current_version.major
                            && latest_version.minor > current_version.minor
                        )) {
                            console.log(latest_version);
                            _this.UpdateAvailable = APP_RELEASES;
                            $scope.$apply();
                        }
                    }
                });
        };

        jnrWebsocket.registrySubscription('AppData/MQTT/ConnectionEstablishedTime',
            function (key, value) {
                if (value && '' !== value) {
                    _this.Status.ConnectionEstablishedTime = value;
                    $scope.$apply();
                }
            });

        jnrWebsocket.registrySubscription('AppData/MQTT/ConnectionLostTime',
            function (key, value) {
                if (value && '' !== value) {
                    _this.Status.ConnectionLostTime = value;
                    $scope.$apply();
                }
            });

        // jnrWebsocket.readRegistryKeys(
        //     ["AppData/MQTT/LastConnectedTime"],
        //     function (key, value) {
        //         if (key.endsWith('LastConnectedTime')) {
        //             _this.Status.LastConnectionTime = value;

        //         }

        //         $scope.$apply();
        //     }
        // );

        // get links to display in Links dropdown menu
        jnrWebsocket.getRegistryListing("Applications", function (registryPath, registryKeys) {
            _this.links = [];

            // this first call will return all of the application folders
            registryKeys.forEach(function (applicationFolderKey) {
                // try to get the applications config web page
                jnrWebsocket.readRegistryKey(applicationFolderKey + "Config", function (registryKey, registryValue) {
                    console.log("    " + registryKey + " = " + registryValue);
                    if (registryValue) {
                        const applicationsConfigRegEx = /Applications\/(\w+)\//;
                        const match = applicationFolderKey.match(applicationsConfigRegEx);
                        var applicationName = match[1];
                        _this.links.push({ 'name': applicationName, 'link': registryValue });
                        $scope.$apply();
                    }
                });
            });

        });
    });



    jnrWebsocket.onClosed = function () {
        _this.Connected = false;

        $scope.$apply();
    };



    _this.hasChanged = function (config, savedConfig) {
        var changed = !angular.equals(config, savedConfig);
        return changed;
    };


    _this.addOutputGroup = function () {
        if (!_this.Config.OutputGroups) _this.Config.OutputGroups = [];
        _this.Config.OutputGroups.push({});
    };


    _this.removeOutputGroup = function (outputGroup) {
        if (_this.Config.OutputGroups && null != _this.Config.OutputGroups) {
            var index = _this.Config.OutputGroups.indexOf(outputGroup);
            if (-1 != index) {
                _this.Config.OutputGroups.splice(index, 1);
            }
        }
    };


    _this.readConfig = function () {
        jniorConfigStorage.readConfig(function (result) {
            if ('Fail' !== result) {
                _this.Config = jniorConfigStorage.Config;
                _this.SavedConfig = angular.copy(_this.Config);
                console.log('Config: ' + _this.Config);
                $scope.$apply();
            }
        });
    };


    _this.saveChangesRequest = function () {
        _this.SaveDialog = bootbox.confirm({
            className: "bb-primary",
            title: "Are you sure you want to save your changes?",
            message: "Your changes will take affect without needing to reboot.",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Save',
                    className: 'btn-primary'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.saveChanges();
                    return false;
                }
            }
        });
        _this.SaveDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });

    };


    _this.saveChanges = function () {
        jniorConfigStorage.Config = _this.Config;
        jniorConfigStorage.saveConfig(function (status) {
            if ('Fail' !== status) {
                _this.SavedConfig = angular.copy(_this.Config);
                $scope.$apply();

                jnrWebsocket.postMessage(APP_ID, { Message: 'config-updated' });

                _this.SaveDialog.modal('hide');
            } else {
                alert('error saving the file');
            }
        });
    };


    _this.cancelChangesRequest = function () {
        _this.CancelDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure you want to cancel your changes?",
            message: "Cancelling your changes will reload the last saved settings",
            buttons: {
                cancel: {
                    label: 'Keep Changes',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Cancel Changes',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.cancelChanges();
                    return false;
                }
            }
        });
        _this.CancelDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };


    _this.cancelChanges = function () {
        _this.Config = angular.copy(_this.SavedConfig);
        $scope.$apply();

        _this.CancelDialog.modal('hide');
    };


    _this.onMessage = function (json) {
        var message = json.Message;

        if ('application.exit' === message) {
            _this.Connected = false;
            $scope.$apply();

        } else if ('current-status' === message) {
            _this.Connected = true;

            _this.Status.ConnectionStatus = json.ConnectionStatus;
            _this.Status.ConnectionInfo = json.ConnectionInfo;
            $scope.$apply();
        }
    };


    _this.sendConnect = function () {
        jnrWebsocket.postMessage(APP_ID, { Message: 'connect' });
    };


    _this.sendDisconnect = function () {
        jnrWebsocket.postMessage(APP_ID, { Message: 'disconnect' });
    };
});