/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.externalmodules;

import com.integ.common.externalmodules.DeviceInfo;
import com.integ.common.externalmodules.ExternalDeviceMap;
import com.integpg.system.ArrayUtils;
import java.beans.PropertyChangeEvent;

public class TempProbeDevice
extends DeviceInfo {
    private static final int READ_INTERVAL = 1000;
    private long _nextReadTime = System.currentTimeMillis();
    private double _celsius = Double.MIN_VALUE;

    public static TempProbeDevice getModuleAtIndex(int moduleIndex) {
        long deviceAddress = DeviceInfo.getModuleAddressAtIndex("Type28", moduleIndex);
        if (-1L != deviceAddress) {
            TempProbeDevice device = new TempProbeDevice(deviceAddress, moduleIndex);
            return device;
        }
        return null;
    }

    public static Object read(int channel, String fieldName) {
        int index = channel;
        TempProbeDevice tempProbe = (TempProbeDevice)ExternalDeviceMap.getByType("Type28_" + index);
        if (null != tempProbe) {
            tempProbe.update();
            if ("c".equalsIgnoreCase(fieldName) || "celsius".equalsIgnoreCase(fieldName)) {
                return tempProbe.getCelsius();
            }
            if ("f".equalsIgnoreCase(fieldName) || "fahrenheit".equalsIgnoreCase(fieldName)) {
                return tempProbe.getFahrenheit();
            }
            throw new RuntimeException("Temp Probe unknown field name: " + fieldName);
        }
        throw new RuntimeException("Temp Probe not present for index " + index);
    }

    public TempProbeDevice(long deviceAddress, int index) {
        super(deviceAddress, index);
    }

    @Override
    public void update() {
        if (System.currentTimeMillis() > this._nextReadTime) {
            long longBits;
            double celsius;
            this._nextReadTime += 1000L;
            byte[] deviceBlock = this.read();
            if (this.Updated && this._celsius != (celsius = Double.longBitsToDouble(longBits = ArrayUtils.getLong((byte[])deviceBlock, (int)0)))) {
                this.alertPropertyChangeListeners(new PropertyChangeEvent(this, "Celsius", this._celsius, celsius));
                this._celsius = celsius;
            }
        }
    }

    public double getCelsius() {
        return this._celsius;
    }

    public double getFahrenheit() {
        return this._celsius * 9.0 / 5.0 + 32.0;
    }
}

