/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.messagepump;

import com.integ.common.logging.Logger;
import com.integ.common.logging.SystemOutLog;
import com.integ.common.messagepump.MessagePumpAppMessageListener;
import com.integ.common.messagepump.MessagePumpEngine;
import com.integ.common.messagepump.MessagePumpListener;
import com.integpg.system.SystemMsg;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Json;

public class MessagePumpAppHandler
implements MessagePumpListener {
    private final Hashtable<String, MessagePumpAppMessageListener> _appMessageListeners = new Hashtable();
    private final int _type;
    private static Logger _log = SystemOutLog.getLogger();
    private SystemMsg _systemMsg;
    private Json _receivedJson;
    private String _messageString;

    public MessagePumpAppHandler(int type) {
        this._type = type;
    }

    public static void setLog(Logger log) {
        _log = log;
    }

    public MessagePumpAppHandler addCommandListener(String command, MessagePumpAppMessageListener listener) {
        this._appMessageListeners.put(command, listener);
        _log.info(String.format("   added handler for %d:%s = %s", command, this._type, listener.getClass().getName()));
        return this;
    }

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (this._type == systemMsg.type) {
            this._systemMsg = systemMsg;
            long start = System.currentTimeMillis();
            this.processMessage();
            long elapsed = System.currentTimeMillis() - start;
            if (100L <= elapsed) {
                _log.warn(String.format("%s processed in %.3f", this._messageString, (double)elapsed / 1000.0));
            }
        }
    }

    private void processMessage() {
        MessagePumpAppMessageListener listener;
        String contentJsonString = new String(this._systemMsg.msg);
        this._receivedJson = new Json(contentJsonString);
        this._messageString = this._receivedJson.getString("Message");
        _log.info(String.format("%s processing %s", this.getClass().getName(), this._messageString));
        if (this._appMessageListeners.containsKey(this._messageString) && null != (listener = this._appMessageListeners.get(this._messageString))) {
            listener.applicationMessageReceived(this._receivedJson);
        }
    }

    private void sendReponse(Json json) throws IOException {
        SystemMsg responseMsg = new SystemMsg();
        responseMsg.type = this._systemMsg.type;
        responseMsg.msg = json.toString().getBytes();
        MessagePumpEngine.postMessage(responseMsg);
    }
}

