/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.logging;

import com.integ.common.logging.BufferedLineOutputStream;
import com.integ.common.logging.FileLogService;
import com.integ.common.logging.LogOutputStream;
import com.integ.common.logging.Logger;
import java.io.PrintStream;
import java.text.QuickDateFormat;

public abstract class FileLog
extends Logger {
    public static final QuickDateFormat LogDateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff zzz");
    protected String _filename;
    private final QuickDateFormat _quickDateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff zzz");
    private final String _firstEntry = String.format("%s, %s", this._quickDateFormat.format(System.currentTimeMillis()), "--------------------------------------------------");
    protected final LogOutputStream _logOutputStream;
    private boolean _firstWrite = true;

    protected FileLog(String filename, LogOutputStream logOutputStream) {
        this._filename = filename;
        this._logOutputStream = logOutputStream;
        super.setPrintStream(new PrintStream(new BufferedLineOutputStream(logOutputStream, 1024)));
    }

    @Override
    public Logger setMaxSizeKB(int maxSizeKB) {
        this._logOutputStream.setMaxSizeKB(maxSizeKB);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void println(String s) {
        FileLog fileLog = this;
        synchronized (fileLog) {
            if (this._firstWrite) {
                super.println(this._firstEntry);
                this._firstWrite = false;
            }
            System.out.println(s);
            this.writeln(String.format("%s, %s", this._quickDateFormat.format(System.currentTimeMillis()), s));
        }
    }

    @Override
    public void writeln(String s) {
        super.print(String.format("%s\r\n", s));
        this._nextFlushTime = System.currentTimeMillis() + 5000L;
        if (this._finalized) {
            this._nextFlushTime = System.currentTimeMillis();
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        FileLog fileLog = this;
        synchronized (fileLog) {
            if (System.currentTimeMillis() >= this._nextFlushTime) {
                this._printStream.flush();
                this._nextFlushTime = Long.MAX_VALUE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        FileLog fileLog = this;
        synchronized (fileLog) {
            if (null != this._filename) {
                System.out.println(String.format("%s finalize", this._filename));
                this._nextFlushTime = System.currentTimeMillis();
                this.flush();
                this._finalized = true;
            }
        }
    }

    static {
        FileLogService.start();
    }
}

