/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.externalmodules;

import com.integ.common.externalmodules.DeviceInfo;
import com.integ.common.externalmodules.ExternalDeviceMap;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import java.beans.PropertyChangeEvent;
import java.io.IOException;

public class EnvironSensorDevice
extends DeviceInfo {
    private double _celsius = Double.MIN_VALUE;
    private double _humidity = Double.MIN_VALUE;
    private static final int READ_INTERVAL = 2000;
    private long _nextReadTime = System.currentTimeMillis();
    private static final int START_ADDR = 32;
    private static final int LENGTH = 32;
    private static final byte[] _initData = new byte[32];
    private int _id;

    public static EnvironSensorDevice getModuleAtIndex(int moduleIndex) {
        long deviceAddress = DeviceInfo.getModuleAddressAtIndex("Type7E", moduleIndex);
        if (-1L != deviceAddress) {
            EnvironSensorDevice device = new EnvironSensorDevice(deviceAddress, moduleIndex);
            return device;
        }
        return null;
    }

    public static Object read(int channel, String fieldName) {
        int index = channel;
        EnvironSensorDevice environSensor = (EnvironSensorDevice)ExternalDeviceMap.getByType("Type7E_" + index);
        if (null != environSensor) {
            environSensor.update();
            if ("c".equalsIgnoreCase(fieldName) || "celsius".equalsIgnoreCase(fieldName)) {
                return environSensor._celsius;
            }
            if ("f".equalsIgnoreCase(fieldName) || "fahrenheit".equalsIgnoreCase(fieldName)) {
                return environSensor.getFahrenheit();
            }
            if ("h".equalsIgnoreCase(fieldName) || "humidity".equalsIgnoreCase(fieldName)) {
                return environSensor._humidity;
            }
            throw new RuntimeException("Temp Probe unknown field name: " + fieldName);
        }
        throw new RuntimeException("Temp Probe not present for index " + index);
    }

    public EnvironSensorDevice(long deviceAddress, int index) {
        super(deviceAddress, index);
    }

    @Override
    public void update() {
        if (System.currentTimeMillis() > this._nextReadTime) {
            this._nextReadTime += 2000L;
            byte[] deviceBlock = this.read();
            if (this.Updated) {
                double celsius = this.getValue(0, 2);
                if (-2.147483648E9 != celsius) {
                    if (-20.0 > (celsius /= 16.0) || 85.0 < celsius) {
                        throw new RuntimeException("celcius temperature out of range: " + celsius);
                    }
                } else {
                    celsius = Double.NaN;
                }
                if (this._celsius != celsius) {
                    this.alertPropertyChangeListeners(new PropertyChangeEvent(this, "Celsius", this._celsius, celsius));
                    this._celsius = celsius;
                }
                if (255 == this._id || 101 == this._id || 104 == this._id) {
                    double humidity = this.getValue(2, 2);
                    humidity = -2.147483648E9 != humidity ? (humidity /= 16.0) : Double.NaN;
                    if (this._humidity != humidity) {
                        this.alertPropertyChangeListeners(new PropertyChangeEvent(this, "Humidity", this._humidity, humidity));
                        this._humidity = humidity;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read() {
        block21: {
            this.Updated = false;
            if (this._present) {
                try {
                    byte[] data = new byte[35];
                    data[0] = -16;
                    data[1] = 32;
                    data[2] = 0;
                    ArrayUtils.arraycopy((Object)_initData, (int)0, (Object)data, (int)3, (int)32);
                    SensorPort sensorPort = SENSOR_PORT;
                    synchronized (sensorPort) {
                        try {
                            SENSOR_PORT.open();
                            SENSOR_PORT.select(this.DeviceAddress);
                            SENSOR_PORT.data(data, 0, data.length);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        finally {
                            try {
                                SENSOR_PORT.close();
                            }
                            catch (Exception exception) {}
                        }
                        this._id = data[3] & 0xFF;
                        if (255 == this._id) {
                            this.Updated = true;
                            this.DeviceBlock = null;
                            throw new IOException("comm err -3");
                        }
                        if (null == this._savedBlock) {
                            this._savedBlock = new byte[30];
                        }
                        boolean bl = this.Updated = !ArrayUtils.arrayComp((Object)this._savedBlock, (int)0, (Object)data, (int)2, (int)30);
                        if (this.Updated) {
                            ArrayUtils.arraycopy((Object)data, (int)5, (Object)this._savedBlock, (int)0, (int)30);
                            this.DeviceBlock = this._savedBlock;
                        }
                    }
                }
                catch (IOException ex) {
                    this.DeviceBlock = null;
                    ++this.FailureCount;
                    System.out.println(String.format("could not read %s device: %s %d times", this.DeviceAddressString, ex.getMessage(), this.FailureCount));
                    if (3 > this.FailureCount) break block21;
                    this._present = false;
                }
            }
        }
        return this.DeviceBlock;
    }

    private int getValue(int idx, int len) {
        if (null == this.DeviceBlock) {
            return Integer.MIN_VALUE;
        }
        int value = 0;
        boolean invalid = true;
        while (len-- > 0) {
            value <<= 8;
            int b = this.DeviceBlock[idx + len] & 0xFF;
            invalid &= b == 255;
            value += b;
        }
        if (invalid) {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    public double getCelsius() {
        return this._celsius;
    }

    public double getFahrenheit() {
        return this._celsius * 9.0 / 5.0 + 32.0;
    }

    public double getHumidity() {
        return this._humidity;
    }

    static {
        for (int n = 0; n < 32; ++n) {
            EnvironSensorDevice._initData[n] = -1;
        }
    }
}

