/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.protocol;

public class ConnectOptions {
    public static final int USERNAME_FLAG = 128;
    public static final int PASSWORD_FLAG = 64;
    public static final int WILL_RETAIN_FLAG = 32;
    public static final int WILL_FLAG = 4;
    public static final int CLEAN_CONNECTION_FLAG = 2;
    private final String _clientId;
    private boolean _cleanConnection;
    private int _keepAliveSeconds = 30;
    private String _willTopic;
    private String _willMessage;
    private int _willQos;
    private boolean _willRetain;
    private String _username;
    private String _password;

    public ConnectOptions(String clientId) {
        this._clientId = clientId;
    }

    public String getClientId() {
        return this._clientId;
    }

    public ConnectOptions setCleanConnection(boolean cleanConnection) {
        this._cleanConnection = cleanConnection;
        return this;
    }

    public ConnectOptions setKeepAliveSeconds(int keepAliveSeconds) {
        this._keepAliveSeconds = keepAliveSeconds;
        return this;
    }

    public int getKeepAliveInSeconds() {
        return this._keepAliveSeconds;
    }

    public ConnectOptions setWillTopic(String willTopic) {
        this._willTopic = willTopic;
        return this;
    }

    public String getWillTopic() {
        return this._willTopic;
    }

    public ConnectOptions setWillMessage(String willMessage) {
        this._willMessage = willMessage;
        return this;
    }

    public String getWillMessage() {
        return this._willMessage;
    }

    public ConnectOptions setWillQos(int willQos) {
        if (0 > willQos || 2 < willQos) {
            throw new IllegalArgumentException("Quality of service must be 0, 1, or 2");
        }
        this._willQos = willQos;
        return this;
    }

    public ConnectOptions setWillRetain(boolean willRetain) {
        this._willRetain = willRetain;
        return this;
    }

    public ConnectOptions setUsername(String username) {
        this._username = username;
        return this;
    }

    public ConnectOptions setPassword(String password) {
        this._password = password;
        return this;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public int getFlags() {
        int flags = 0;
        if (this._cleanConnection) {
            flags |= 2;
        }
        if (null != this._willTopic && !"".equals(this._willTopic) && null != this._willMessage && !"".equals(this._willMessage)) {
            flags |= 4;
            flags |= this._willQos << 3;
            if (this._willRetain) {
                flags |= 0x20;
            }
            if (null != this._username && !"".equals(this._username)) {
                flags |= 0x80;
            }
            if (null != this._password && !"".equals(this._password)) {
                flags |= 0x40;
            }
        }
        return flags;
    }
}

