/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.utils;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.system.JANOS;

public class ApplicationUtils {
    public static boolean isBackground() {
        int thisProcessId = JANOS.getProcessID();
        String thisProcessName = JANOS.getProcessName((int)thisProcessId);
        boolean isBackground = thisProcessName.startsWith("Run");
        if (!isBackground) {
            int lastSlashPos = thisProcessName.indexOf("/", 8);
            String thisProcessParent = thisProcessName.substring(0, lastSlashPos);
            if (!thisProcessParent.startsWith("Command")) {
                isBackground = true;
            } else {
                int[] processIds = JANOS.getProcessIDs();
                for (int i = 0; i < processIds.length && !isBackground; ++i) {
                    String processName;
                    int processId = processIds[i];
                    if (thisProcessId == processId || (processName = JANOS.getProcessName((int)processId)).length() < lastSlashPos) continue;
                    isBackground = thisProcessParent.equals(processName);
                }
            }
        }
        return isBackground;
    }

    public static void duplicateInstanceCheck(String appName) {
        if (1 < JANOS.registerProcess((String)appName)) {
            AppLog.error("another instance of " + appName + " is running");
            System.exit(-1);
        }
    }
}

