function checkForUpdate(appname, currentVersionString, callback) {

    try {
        // build the url to call
        var url = 'https://jnior.com/jrget/?appname=' + appname;
        console.log('GET: ' + url);
        var httpRequest = new XMLHttpRequest();
        httpRequest.open('GET', url);
        httpRequest.onreadystatechange = function () {
            if (httpRequest.readyState == 4 && httpRequest.status == 200) {

                // the response was successful
                var response = httpRequest.responseText;
                var json = JSON.parse(response);

                // parse the current version passed in
                currentVersion = parseVersion(currentVersionString);

                // parse the latest version from the response
                latestVersion = parseVersion(json.latest_version.version);

                // if the latest version is more recent then call the provided callback
                if (latestVersion.major > currentVersion.major || (
                    latestVersion.major == currentVersion.major
                    && latestVersion.minor > currentVersion.minor
                )) {
                    if (callback) callback(json);
                }
            }
        }
        httpRequest.send();
    } catch (err) {
        console.error(err);
    }
}



function parseVersion(str) {
    if (typeof (str) != 'string') { return false; }

    var arr = str.split('.');

    // parse int or default to 0
    var maj = parseInt(arr[0]) || 0;
    var min = parseInt(arr[1]) || 0;
    var rest = parseInt(arr[2]) || 0;
    return {
        major: maj,
        minor: min,
        build: rest
    }
}