/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.text;

import com.integpg.system.Timebase;
import java.util.Calendar;

public class JDateFormat {
    private final Calendar _calendar = Calendar.getInstance();
    private long _nextHourMillis = -1L;
    private long _lastMinuteMillis = -1L;
    private long _nextMinuteMillis = -1L;
    private String _dateFormatString = "MM/dd/yy";
    private String _dateString;
    private String _dateStringCache;
    private String _timezoneString;
    private boolean _includeMilliseconds = false;
    private boolean _includeTimezone = false;

    public JDateFormat setDateFormat(String dateFormatString) {
        this._dateFormatString = dateFormatString;
        return this;
    }

    public JDateFormat includeMilliseconds(boolean include) {
        this._includeMilliseconds = include;
        return this;
    }

    public JDateFormat includeTimezone(boolean include) {
        this._includeTimezone = include;
        return this;
    }

    public String format() {
        return this.format(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(long timeMillis) {
        Calendar calendar = this._calendar;
        synchronized (calendar) {
            this.update(timeMillis);
            long sinceLastMinute = timeMillis - this._lastMinuteMillis;
            int second = (int)(sinceLastMinute / 1000L);
            int millisecond = (int)(sinceLastMinute % 1000L);
            if (this._includeMilliseconds && this._includeTimezone) {
                return String.format("%s:%02d.%03d %s", this._dateStringCache, second, millisecond, this._timezoneString);
            }
            if (this._includeMilliseconds) {
                return String.format("%s:%02d.%03d", this._dateStringCache, second, millisecond);
            }
            if (this._includeTimezone) {
                return String.format("%s:%02d %s", this._dateStringCache, second, this._timezoneString);
            }
            return String.format("%s:%02d", this._dateStringCache, second);
        }
    }

    private void update(long timeMillis) {
        if (timeMillis >= this._nextMinuteMillis) {
            this._lastMinuteMillis = timeMillis - timeMillis % 60000L;
            this._nextMinuteMillis = this._lastMinuteMillis + 60000L;
            this._calendar.setTimeInMillis(System.currentTimeMillis());
            int minute = this._calendar.get(12);
            int hour = this._calendar.get(11);
            if (timeMillis >= this._nextHourMillis) {
                this._nextHourMillis = timeMillis - timeMillis % 3600000L + 3600000L;
                int year = this._calendar.get(1);
                int month = this._calendar.get(2) + 1;
                int day = this._calendar.get(5);
                this._dateString = String.format("%02d/%02d/%02d", month, day, year % 100);
                if (this._includeTimezone) {
                    String dstString;
                    this._timezoneString = Timebase.getTimeZone();
                    if (Timebase.isDST((long)System.currentTimeMillis(), (String)this._timezoneString) && null != (dstString = Timebase.getDSTTimeZone((String)this._timezoneString))) {
                        this._timezoneString = dstString;
                    }
                }
            }
            this._dateStringCache = String.format("%s %02d:%02d", this._dateString, hour, minute);
        }
    }
}

