/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.protocol;

import com.integ.mqtt.protocol.ConnectOptions;
import com.integ.mqtt.protocol.MqttOutgoingPacket;
import java.io.IOException;

class ConnectPacket
extends MqttOutgoingPacket {
    private final ConnectOptions _connectOptions;

    public ConnectPacket(ConnectOptions connectOptions) {
        this._packetType = 1;
        this._connectOptions = connectOptions;
    }

    @Override
    protected void build() throws IOException {
        this.writeString(this._variableHeader, "MQTT");
        this._variableHeader.write(4);
        if (null == this._connectOptions) {
            throw new RuntimeException("Connection Options are not defined");
        }
        int flags = this._connectOptions.getFlags();
        this._variableHeader.write(flags);
        this._variableHeader.writeShort(this._connectOptions.getKeepAliveInSeconds());
        this.writeString(this._variableHeader, this._connectOptions.getClientId());
        if (0 != (flags & 4)) {
            this.writeString(this._variableHeader, this._connectOptions.getWillTopic());
            this.writeString(this._variableHeader, this._connectOptions.getWillMessage());
        }
        if (0 != (flags & 0x80)) {
            this.writeString(this._variableHeader, this._connectOptions.getUsername());
        }
        if (0 != (flags & 0x40)) {
            this.writeString(this._variableHeader, this._connectOptions.getPassword());
        }
    }
}

