/*
 * Decompiled with CFR 0.152.
 */
package com.integ.modbustomqtt;

import com.integ.janoslib.protocols.modbus.connections.ModbusConnection;
import com.integ.janoslib.protocols.modbus.protocols.ModbusProtocol;
import com.integ.modbustomqtt.DataTagPollEngine;
import com.integ.modbustomqtt.ModbusDataTag;
import com.integpg.janoslib.logger.Log;
import java.util.ArrayList;
import java.util.Json;

public class ModbusSlave {
    protected Log _log;
    protected final String _slaveName;
    private final int _timeout;
    private final int _retries;
    private final ArrayList<ModbusDataTag> _modbusDataTags = new ArrayList();
    protected ModbusConnection _modbusConnection = null;
    protected ModbusProtocol _modbusProtocol = null;
    private DataTagPollEngine _dataTagPollEngine = null;

    public ModbusSlave(Json slaveJson) {
        Json[] tagsJsonArray;
        this._slaveName = slaveJson.getString("SlaveName");
        this._timeout = slaveJson.getInt("Timeout");
        this._retries = slaveJson.getInt("Retries");
        for (Json tagJson : tagsJsonArray = (Json[])slaveJson.get("Tags")) {
            ModbusDataTag modbusDataTag = new ModbusDataTag(this, tagJson);
            this._modbusDataTags.add(modbusDataTag);
        }
    }

    public Log getLog() {
        return this._log;
    }

    public String getSlaveName() {
        return this._slaveName;
    }

    public int getRetries() {
        return this._retries;
    }

    public ModbusDataTag[] getDataTags() {
        return (ModbusDataTag[])this._modbusDataTags.toArray();
    }

    public ModbusConnection getModbusConnection() {
        return this._modbusConnection;
    }

    public ModbusProtocol getModbusProtocol() {
        return this._modbusProtocol;
    }

    void startScanning() {
        if (null == this._dataTagPollEngine) {
            this._dataTagPollEngine = new DataTagPollEngine(this);
            this._dataTagPollEngine.start();
        }
    }

    void stopScanning() {
        if (null != this._dataTagPollEngine) {
            try {
                this._dataTagPollEngine.stop();
            }
            catch (InterruptedException ex) {
                this._log.error("error terminating modbus scanning", ex);
            }
        }
    }
}

