/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.protocols.modbus.connections;

import com.integ.janoslib.protocols.modbus.connections.ModbusConnection;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.SerialInputStream;
import com.integpg.comm.SerialPort;
import com.integpg.comm.SerialPortEvent;
import com.integpg.comm.SerialPortEventListener;
import com.integpg.comm.UnsupportedCommOperationException;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialModbusConnection
extends ModbusConnection
implements SerialPortEventListener {
    private SerialPort _serialPort;
    private boolean _is485 = false;
    private int _lastBytesWritten;
    private byte[] _skipBytes = new byte[128];

    public SerialModbusConnection(String portName, int baudRate, int dataBits, int stopBits, int parity) {
        AppLog.info("Creating MODBUS Connection on " + portName + " port");
        if (portName.equalsIgnoreCase("none")) {
            throw new IllegalArgumentException("Serial port not selected");
        }
        if (portName.equalsIgnoreCase("aux")) {
            this._serialPort = new AUXSerialPort();
        } else if (portName.equalsIgnoreCase("com")) {
            this._serialPort = new COMSerialPort();
        }
        if (this._serialPort != null) {
            try {
                this._serialPort.open();
                this._serialPort.disableReceiveTimeout();
                this._serialPort.setSerialPortParams(baudRate, dataBits, stopBits, parity);
                this._serialPort.setInputBufferSize(512);
                AppLog.info("Set Serial Input Buffer to " + this._serialPort.getInputBufferSize() + " bytes");
                this._serialPort.addEventListener((SerialPortEventListener)this);
                this._serialPort.notifyOnFramingError(true);
                this._serialPort.notifyOnOverrunError(true);
                this._serialPort.notifyOnOverrunError(true);
                this._serialPort.notifyOnParityError(true);
                this._serialPort.notifyOnBreakInterrupt(true);
                SerialInputStream inputStream = this._serialPort.getInputStream();
                inputStream.skip(inputStream.available());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setSerialPortParams(int baudRate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        this._serialPort.setSerialPortParams(baudRate, dataBits, stopBits, parity);
    }

    public void setRS485(boolean is485) {
        this._is485 = is485;
        if (is485) {
            AppLog.info("Setting MODBUS Connection to use RS-485");
            ((AUXSerialPort)this._serialPort).setRS485(is485);
        }
    }

    public void enableReceiveTimeout(int timeout) throws UnsupportedCommOperationException {
        AppLog.info("Setting MODBUS Connection read timeout to " + timeout);
        this._serialPort.enableReceiveTimeout(timeout);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._serialPort.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this._serialPort.getOutputStream();
    }

    @Override
    public void beginWrite() {
        try {
            this._serialPort.enableReceiveTimeout(1000);
        }
        catch (UnsupportedCommOperationException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void endWrite(int bytesWritten) {
        this._serialPort.disableReceiveTimeout();
    }

    @Override
    public void endWrite(byte[] bytes, int offset, int length) {
        if (this._is485) {
            try {
                ((AUXSerialPort)this._serialPort).enableDrivers(true);
                this._lastBytesWritten = length;
                int bytesAvailableAtStartOfQuery = this._serialPort.getInputStream().available();
                if (0 < bytesAvailableAtStartOfQuery) {
                    AppLog.warn("there are bytes available at the start of the query: " + bytesAvailableAtStartOfQuery);
                    this._serialPort.getInputStream().skip((long)bytesAvailableAtStartOfQuery);
                }
                this._serialPort.getOutputStream().write(bytes, 0, length);
                this._serialPort.getOutputStream().flush();
                long expire = System.currentTimeMillis() + 1000L;
                while (this._serialPort.getInputStream().available() < length) {
                    if (System.currentTimeMillis() <= expire) continue;
                    AppLog.info("reading sent bytes expired: " + this._serialPort.getInputStream().available());
                    break;
                }
                ((AUXSerialPort)this._serialPort).enableDrivers(false);
                if (length <= this._serialPort.getInputStream().available()) {
                    this._serialPort.getInputStream().read(this._skipBytes, 0, length);
                    if (!ArrayUtils.arrayComp((Object)bytes, (int)0, (Object)this._skipBytes, (int)0, (int)length)) {
                        AppLog.info("sent bytes not echoed");
                        AppLog.info("< " + HexUtils.bytesToHex(this._skipBytes, 0, length));
                    }
                } else {
                    AppLog.error("sent bytes not echoed");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void serialEvent(SerialPortEvent ev) {
        switch (ev.getEventType()) {
            case 2: {
                JANOS.syslog((String)"** parity error");
                break;
            }
            case 8: {
                JANOS.syslog((String)"** framing error");
                break;
            }
            case 4: {
                JANOS.syslog((String)"** overrun error");
                break;
            }
            case 64: {
                JANOS.syslog((String)"** break condition");
                break;
            }
            default: {
                JANOS.syslog((String)"** unknown event");
            }
        }
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }
}

