function Slave() {
    var _this = this;
    _this.SlaveName = 'New Slave';
    _this.Type = 'TCP';
    _this.Address = '';
    _this.Port = 502;
    _this.SlaveId = 1;
    _this.Timeout = 5000;
    _this.Retries = 3;

    _this.Tags = [];


    _this.addTag = function () {
        _this.Tags.push(new Tag());
    };


    _this.removeTag = function (tag) {
        var indexOf = _this.Tags.indexOf(tag);
        _this.Tags.splice(indexOf, 1);
    };


    _this.parse = function (json) {
        if (json) {
            for (var prop in json) {
                if ('Tags' === prop) {
                    var tagsJsonArray = json[prop];
                    tagsJsonArray.forEach(function (tagJson) {
                        var tag = new Tag();
                        tag.parse(tagJson)
                        _this.Tags.push(tag);
                    });

                } else if (json.hasOwnProperty(prop)) {
                    this[prop] = json[prop];

                }
            }
        }
    };
}



function Tag() {
    var _this = this;
    _this.TagName = 'New Tag';
    _this.Address = '';
    _this.DataType = '';
    _this.ScanRate = 5000;
    _this.Tolerance = 0;
    _this.Id = idGenerator();

    _this.parse = function (json) {
        if (json) {
            for (var prop in json) {
                if (json.hasOwnProperty(prop)) {
                    this[prop] = json[prop];
                }
            }
        }
    };
}



function idGenerator() {
    var S4 = function () {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    return (S4() + S4());
}