/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.JanosLib;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.ApplicationWatchdog;
import com.integpg.janoslib.system.AssemblyBase;
import com.integpg.janoslib.system.ReleaseInfo;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Json;

public class Application {
    private static AssemblyBase _assemblyBase;
    private static String _instanceName;
    private static String _registryRoot;
    private static boolean _isBackground;

    public static void init(AssemblyBase assemblyInfo) {
        Application.init(assemblyInfo, null);
    }

    public static void init(AssemblyBase assemblyInfo, String instanceName) {
        _assemblyBase = assemblyInfo;
        _instanceName = instanceName;
        _registryRoot = "AppData/" + _assemblyBase.getName() + "/";
        if (null != _instanceName) {
            _registryRoot = _registryRoot + _instanceName + "/";
        }
        JANOS.setRegistryString((String)(_registryRoot + "$Version"), (String)_assemblyBase.getVersion());
        JANOS.setRegistryString((String)(_registryRoot + "$BuildTime"), (String)_assemblyBase.getBuildTime());
        JANOS.setRegistryString((String)(_registryRoot + "$JanosLibVersion"), (String)JanosLib.getVersion());
        JANOS.setRegistryString((String)(_registryRoot + "$JanosLibBuildTime"), (String)JanosLib.getBuildTime());
        _isBackground = Application.setIsBackground();
        Application.logBanner();
        try {
            Json releaseNotesJson = Application.getReleaseNotesJson(assemblyInfo);
            FileUtils.writeAllBytes(Application.getAppName().toLowerCase() + "_releasenotes.json", releaseNotesJson.toString().getBytes());
        }
        catch (Exception ex) {
            AppLog.warn("error writing release notes");
        }
        try {
            String releaseNotes = Application.printReleaseNotes(assemblyInfo);
            FileUtils.writeAllBytes(Application.getAppName().toLowerCase() + "_releasenotes.txt", releaseNotes.getBytes());
        }
        catch (Exception ex) {
            AppLog.warn("error writing release notes");
        }
        if (_isBackground) {
            System.setOut(null);
        }
    }

    public static String getAppName() {
        return _assemblyBase.getName();
    }

    public static String getAppInstanceName() {
        String name = _assemblyBase.getName();
        if (null != _instanceName) {
            name = name + "-" + _instanceName;
        }
        return name;
    }

    public static String getAppVersion() {
        return _assemblyBase.getVersion();
    }

    public static String getInstanceName() {
        return _instanceName;
    }

    public static String getUuid() {
        return _assemblyBase.getUUID();
    }

    public static String getRegistryRoot() {
        return _registryRoot;
    }

    public static boolean isBackground() {
        return _isBackground;
    }

    private static boolean setIsBackground() {
        int thisProcessId = JANOS.getProcessID();
        String thisProcessName = JANOS.getProcessName((int)thisProcessId);
        boolean isBackground = thisProcessName.startsWith("Run");
        if (!isBackground) {
            int lastSlashPos = thisProcessName.indexOf("/", 8);
            String thisProcessParent = thisProcessName.substring(0, lastSlashPos);
            if (!thisProcessParent.startsWith("Command")) {
                isBackground = true;
            } else {
                int[] processIds = JANOS.getProcessIDs();
                for (int i = 0; i < processIds.length && !isBackground; ++i) {
                    String processName;
                    int processId = processIds[i];
                    if (thisProcessId == processId || (processName = JANOS.getProcessName((int)processId)).length() < lastSlashPos) continue;
                    isBackground = thisProcessParent.equals(processName);
                }
            }
        }
        return isBackground;
    }

    public static String printReleaseNotes(AssemblyBase assemblyBase) {
        StringBuilder sb = new StringBuilder();
        sb.append("Version: " + assemblyBase.getVersion() + "\r\n\r\n");
        ReleaseInfo[] releaseNotes = AssemblyBase.getReleaseNotes();
        if (null != releaseNotes) {
            for (ReleaseInfo releaseInfo : releaseNotes) {
                String releaseInfoString = releaseInfo.getVersion() + "          ";
                releaseInfoString = releaseInfoString.substring(0, 10) + releaseInfo.getDate();
                sb.append(releaseInfoString + "\r\n");
                for (String note : releaseInfo.getReleaseNotes()) {
                    int maxLineLength = 90;
                    int pos = 0;
                    int endPos = 0;
                    while (pos < note.length()) {
                        if (note.length() < (endPos += maxLineLength)) {
                            endPos = note.length();
                        } else {
                            int lastSpacePos = note.lastIndexOf(" ", endPos);
                            if (pos < lastSpacePos) {
                                endPos = lastSpacePos + 1;
                            }
                        }
                        if (0 == pos) {
                            sb.append("        * ");
                        } else {
                            sb.append("          ");
                        }
                        sb.append(note.substring(pos, endPos) + "\r\n");
                        pos = endPos;
                    }
                }
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    private static Json getReleaseNotesJson(AssemblyBase assemblyBase) {
        Json json = new Json();
        json.put("CurrentVersion", (Object)assemblyBase.getVersion());
        json.put("BuildTime", (Object)assemblyBase.getBuildTime());
        ArrayList<Json> releaseInfoJsonArray = new ArrayList<Json>();
        for (ReleaseInfo releaseInfo : assemblyBase.getReleaseNotes()) {
            Json releaseInfoJson = new Json();
            releaseInfoJson.put("Version", (Object)releaseInfo.getVersion());
            releaseInfoJson.put("Date", (Object)releaseInfo.getDate());
            releaseInfoJson.put("Notes", (Object)((String[])releaseInfo.getReleaseNotes().toArray()));
            releaseInfoJsonArray.add(releaseInfoJson);
        }
        json.put("ReleaseNotes", (Object)((Json[])releaseInfoJsonArray.toArray()));
        return json;
    }

    private static void logBanner() {
        String versionString = Application.getAppInstanceName() + " v" + _assemblyBase.getVersion();
        boolean isForeground = !_isBackground;
        AppLog.vital(versionString);
        if (!_assemblyBase.getBuildTime().equals("")) {
            AppLog.vital(" build-time: " + _assemblyBase.getBuildTime());
        }
        AppLog.vital(" using Janos Lib v" + JanosLib.getVersion());
        AppLog.vital(" running on JANOS " + JANOS.getVersion());
        AppLog.vital(String.format(" run as process %d%s", JANOS.getProcessID(), isForeground ? " in FOREGROUND" : ""));
        AppLog.vital("Serial Number: " + UnitConfig.SERIAL_NUMBER + ", Model: " + UnitConfig.MODEL);
        Object[] objectArray = new Object[3];
        objectArray[0] = versionString;
        objectArray[1] = isForeground ? " (foreground)" : "";
        objectArray[2] = _assemblyBase.getBuildTime();
        JANOS.syslog((String)String.format("-- %s%s built %s", objectArray));
        Application.updateBootLog();
    }

    private static void updateBootLog() {
        try {
            QuickDateFormat quickDateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss zzz");
            Object[] objectArray = new Object[7];
            objectArray[0] = quickDateFormat.format(System.currentTimeMillis());
            objectArray[1] = Application.getAppInstanceName();
            objectArray[2] = _assemblyBase.getVersion();
            objectArray[3] = _assemblyBase.getBuildTime();
            objectArray[4] = JanosLib.getVersion();
            objectArray[5] = JanosLib.getBuildTime();
            objectArray[6] = JANOS.getVersion();
            String entry = String.format("%s, %s v%s (built %s) using JanosLib v%s (built %s) running on JANOS %s\r\n", objectArray);
            File bootlogFile = new File(Application.getAppName().toLowerCase() + "_boot.log");
            if (16384L < bootlogFile.length() + (long)entry.length()) {
                File bakFile = new File(bootlogFile.getPath() + ".bak");
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                bootlogFile.renameTo(bakFile);
            }
            FileUtils.appendAllBytes(bootlogFile.getPath(), entry.toString().getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void enableApplicationWatchdog(int watchdogAction) {
        ApplicationWatchdog applicationWatchdog = new ApplicationWatchdog(watchdogAction);
        applicationWatchdog.start();
    }

    public static void sleepForever() {
        try {
            System.out.println("sleep forever");
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static void exit(int status) {
        System.exit(status);
    }

    static {
        _instanceName = null;
        _registryRoot = "";
        _isBackground = false;
    }
}

