/*
 * Decompiled with CFR 0.152.
 */
package com.integ.modbustomqtt;

import com.integ.janoslib.protocols.modbus.connections.SerialModbusConnection;
import com.integ.modbustomqtt.ModbusSlave;
import com.integ.modbustomqtt.SerialConfig;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.utils.StringUtils;
import java.util.Json;

public class ModbusSerialSlave
extends ModbusSlave {
    protected static final SerialModbusConnection SERIAL_MODBUS_CONNECTION = new SerialModbusConnection("aux", 9600, 8, 1, 0);
    protected final int _slaveId;

    public ModbusSerialSlave(Json slaveJson) {
        super(slaveJson);
        this._slaveId = slaveJson.getInt("SlaveId");
        try {
            String nonSpaceSlaveName = StringUtils.replaceAll(this._slaveName, " ", "_");
            String logFileName = Application.getAppName() + "_modbusserial_" + nonSpaceSlaveName + ".log";
            System.out.println("logFileName: " + logFileName);
            this._log = FileLog.getLog(new LogOptions(logFileName).setMaxFileSizeInKb(64));
            this._log.info(slaveJson.toString());
            this._modbusConnection = SERIAL_MODBUS_CONNECTION;
            ((SerialModbusConnection)this._modbusConnection).setRS485(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            SERIAL_MODBUS_CONNECTION.setSerialPortParams(SerialConfig.getBaudRate(), SerialConfig.getDataBits(), SerialConfig.getStopBits(), SerialConfig.getParity());
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
    }
}

