/*
 * Decompiled with CFR 0.152.
 */
package com.integ.modbustomqtt;

import com.integ.modbustomqtt.ModbusSlave;
import com.integ.modbustomqtt.ModbusSlaveFactory;
import com.integ.modbustomqtt.SerialConfig;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Json;

public class Config {
    private static final File CONFIG_FILE = new File("/flash/modbustomqtt/config.json");
    private static Json _configJson = null;
    private static ArrayList<ModbusSlave> _slaveCollection = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        long start;
        block10: {
            ModbusSlave[] slaves = Config.getSlaves();
            if (0 < slaves.length) {
                for (ModbusSlave slave : slaves) {
                    slave.stopScanning();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            new File("/flash/modbustomqtt").mkdir();
            start = System.currentTimeMillis();
            try {
                if (!CONFIG_FILE.exists()) break block10;
                File file = CONFIG_FILE;
                synchronized (file) {
                    String fileContents = FileUtils.readAllText(CONFIG_FILE.getPath());
                    _configJson = new Json(fileContents);
                    System.out.println("_configJson: " + _configJson);
                    SerialConfig.load((Json)_configJson.get("Serial"));
                    Config.loadSlaves();
                    for (ModbusSlave slave : slaves = Config.getSlaves()) {
                        slave.startScanning();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        long elapsed = System.currentTimeMillis() - start;
        AppLog.info("Loaded configuration in " + (double)elapsed / 1000.0 + " seconds");
    }

    private static void loadSlaves() {
        Json[] slavesJsonArray;
        for (Json slaveJson : slavesJsonArray = (Json[])_configJson.get("Slaves")) {
            ModbusSlave modbusSlave = ModbusSlaveFactory.getSlave(slaveJson);
            _slaveCollection.add(modbusSlave);
        }
    }

    public static ModbusSlave[] getSlaves() {
        return (ModbusSlave[])_slaveCollection.toArray();
    }
}

