/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.protocols.modbus.protocols;

import com.integ.janoslib.protocols.modbus.connections.TcpModbusConnection;
import com.integ.janoslib.protocols.modbus.functions.ModbusPdu;
import com.integ.janoslib.protocols.modbus.protocols.ModbusProtocol;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ModbusTCPProtocol
extends ModbusProtocol {
    private final TcpModbusConnection _modbusConnection;
    private int _transactionIdentifier = 0;
    private final int _unitId;
    private final ByteArrayOutputStream _baos = new ByteArrayOutputStream();
    private final DataOutputStream _dos = new DataOutputStream(this._baos);
    private final byte[] _responseBuffer = new byte[7];

    public ModbusTCPProtocol(TcpModbusConnection modbusConnection, int unitId) {
        this._modbusConnection = modbusConnection;
        this._unitId = unitId;
    }

    @Override
    public void write(ModbusPdu pdu) throws Exception {
        try {
            byte[] data = pdu.getData();
            this._baos.reset();
            this._dos.writeShort(++this._transactionIdentifier);
            this._dos.writeShort(0);
            this._dos.writeShort(data.length + 2);
            this._dos.write(this._unitId);
            this._dos.write(pdu.getFunctionCode());
            this._dos.write(pdu.getData());
            byte[] bytes = this._baos.toByteArray();
            this._log.info("<- " + HexUtils.bytesToHex(bytes, 0, bytes.length));
            this._modbusConnection.beginWrite();
            OutputStream outputStream = this._modbusConnection.getOutputStream();
            outputStream.write(bytes, 0, bytes.length);
            outputStream.flush();
            this._modbusConnection.endWrite(bytes.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Error writing to modbus tcp connection", ex);
            this._modbusConnection.closeConnection();
            throw ex;
        }
    }

    @Override
    public void read(ModbusPdu pdu) throws Exception {
        try {
            int bytesRead;
            InputStream inputStream = this._modbusConnection.getInputStream();
            for (int pos = 0; 7 > pos; pos += bytesRead) {
                bytesRead = inputStream.read(this._responseBuffer, pos, 7 - pos);
                if (0 < bytesRead) continue;
                throw new Exception("Unable to read response header.  Not all bytes available.  Read " + pos + " bytes");
            }
            int transactionIdentifier = ArrayUtils.getShort((byte[])this._responseBuffer, (int)0) & 0xFFFF;
            int protocolIdentifier = ArrayUtils.getShort((byte[])this._responseBuffer, (int)2) & 0xFFFF;
            int lengthToFollow = ArrayUtils.getShort((byte[])this._responseBuffer, (int)4) & 0xFFFF;
            byte unitId = this._responseBuffer[6];
            byte[] inBytes = new byte[lengthToFollow - 1];
            inputStream.read(inBytes);
            this._log.info("-> " + HexUtils.bytesToHex(inBytes, 0, inBytes.length));
            pdu.setResponse(inBytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

