App.controller('Controller', function ($scope, $location) {
    var _this = this;
    _this.SerialNumber = '#########';
    _this.Config = {};
    _this.SavedConfig = angular.copy(_this.Config);
    _this.Tags = [];


    // instantiate our JniorConfigStorage class and pass in our websocket object
    var jniorConfigStorage = new JniorConfigStorage(jnrWebsocket, '/flash/modbustomqtt/config.json');

    // onLoggedIn callback.  this is where we will read the config file
    jnrWebsocket.addOnLoggedInListener(function onLoggedIn() {
        console.log('onLoggedIn');
        _this.readConfig();

        jnrWebsocket.readRegistryKeys(
            ["$serialnumber", "ipconfig/hostname"],
            function (key, value) {
                if (key.endsWith('serialnumber')) _this.SerialNumber = value;
                else if (key.endsWith('hostname')) _this.HostName = value;

                $scope.$apply();
            }
        );

        jnrWebsocket.addEventListener('onMessage', _this.onMessage);
        jnrWebsocket.postMessage(APP_ID, { Message: 'get-tags' });

        $scope.$apply();
    });


    _this.hasChanged = function (config, savedConfig) {
        var changed = !angular.equals(config, savedConfig);
        return changed;
    };


    _this.setSelectedSlave = function (slave) {
        if (!_this.validate()) return;
        _this.SelectedSlave = slave;
    };


    _this.addSlave = function (slave) {
        if (!_this.validate()) return;
        if (!_this.Config.Slaves) _this.Config.Slaves = [];
        if (null === slave || undefined === slave) slave = new Slave();
        _this.Config.Slaves.push(slave);
    };


    _this.removeSlave = function (slave) {
        var indexOf = _this.Config.Slaves.indexOf(slave);
        if (-1 !== indexOf) {
            _this.Config.Slaves.splice(indexOf, 1);
        }
    };


    _this.readConfig = function () {
        jniorConfigStorage.readConfig(function (result) {
            if ('Fail' !== result) {
                _this.Config = {};
                jniorConfigStorage.Config.Slaves.forEach(function (element) {
                    var slave = new Slave();
                    slave.parse(element);
                    _this.addSlave(slave);
                });
                _this.Config.Serial = jniorConfigStorage.Config.Serial;

                _this.SavedConfig = angular.copy(_this.Config);
                console.log('Config: ' + _this.Config);

                $scope.$apply();
            }
        });
    };


    _this.validate = function () {
        if (!$scope.modbusMasterForm.$valid) {
            bootbox.alert({
                className: 'bb-danger',
                title: 'Errors detected',
                message: 'There are errors.  Please fix the errors and try again.'
            });
            return false;
        }
        return true;
    };


    _this.saveChangesRequest = function () {
        if (!_this.validate()) return;

        _this.SaveDialog = bootbox.confirm({
            className: "bb-primary",
            title: "Are you sure you want to save your changes?",
            message: "Your changes will take affect without needing to reboot.",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Save',
                    className: 'btn-primary'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.saveChanges();
                    return false;
                }
            }
        });
        _this.SaveDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });

    };


    _this.saveChanges = function () {
        jniorConfigStorage.Config = _this.Config;
        jniorConfigStorage.saveConfig(function (status) {
            if ('Fail' !== status) {
                _this.SavedConfig = angular.copy(_this.Config);
                $scope.$apply();

                jnrWebsocket.postMessage(APP_ID, { Message: 'config-updated' });

                _this.SaveDialog.modal('hide');
            } else {
                alert('error saving the file');
            }
        });
    };


    _this.cancelChangesRequest = function () {
        _this.CancelDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure you want to cancel your changes?",
            message: "Cancelling your changes will reload the last saved settings",
            buttons: {
                cancel: {
                    label: 'Keep Changes',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Cancel Changes',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.cancelChanges();
                    return false;
                }
            }
        });
        _this.CancelDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };


    _this.cancelChanges = function () {
        _this.Config = angular.copy(_this.SavedConfig);
        $scope.$apply();

        _this.CancelDialog.modal('hide');
    };


    _this.onMessage = function (json) {
        var message = json.Message;

        if ('tag-read' === message) {
            // get the id of the tag read.  then find the tag within the slaves based on that id
            var tagId = json.TagId;

            _this.Config.Slaves.forEach(function (slave) {
                slave.Tags.forEach(function (tag) {
                    if (tagId === tag.Id) {
                        _this.Tags[tag.Id] = {};
                        _this.Tags[tag.Id].Status = json.Status;
                        _this.Tags[tag.Id].Value = json.Value;
                        _this.Tags[tag.Id].LastUpdate = moment(json.LastUpdateTime * 1000).format('H:mm:ss');
                        _this.Tags[tag.Id].UpdateCount = json.UpdateCount;
                    }
                });
            });

            $scope.$apply();
        }
    };

});