/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.protocols.modbus.protocols;

import com.integ.janoslib.protocols.modbus.connections.ModbusConnection;
import com.integ.janoslib.protocols.modbus.functions.ModbusPdu;
import com.integ.janoslib.protocols.modbus.functions.ReadHoldingRegisters;
import com.integ.janoslib.protocols.modbus.functions.ReadInputRegisters;
import com.integ.janoslib.protocols.modbus.protocols.ModbusProtocol;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ModbusRTUProtocol
extends ModbusProtocol {
    private final ModbusConnection _modbusConnection;
    private final int _slaveId;
    private InputStream _inputStream = null;
    private DataInputStream _dataInputStream = null;
    private OutputStream _outputStream = null;
    private DataOutputStream _dataOutputStream;
    private final ByteArrayOutputStream _baos = new ByteArrayOutputStream();
    private final DataOutputStream _dos = new DataOutputStream(this._baos);

    public ModbusRTUProtocol(ModbusConnection modbusConnection, int slaveId) {
        this._modbusConnection = modbusConnection;
        this._slaveId = slaveId;
        try {
            this._inputStream = this._modbusConnection.getInputStream();
            this._dataInputStream = new DataInputStream(this._inputStream);
            this._inputStream.skip(this._inputStream.available());
        }
        catch (Exception ex) {
            this._log.error(ex);
        }
    }

    @Override
    public void write(ModbusPdu pdu) {
        try {
            OutputStream outputStream = this._modbusConnection.getOutputStream();
            if (this._outputStream != outputStream) {
                this._outputStream = outputStream;
                this._dataOutputStream = new DataOutputStream(outputStream);
            }
            this._baos.reset();
            this._dos.writeByte(this._slaveId);
            this._dos.writeByte(pdu.getFunctionCode());
            this._dos.write(pdu.getData());
            int crc = JANOS.CRC16((byte[])this._baos.toByteArray(), (int)0, (int)this._baos.size(), (int)65535);
            crc = ArrayUtils.swapEndian((short)((short)crc));
            this._dos.writeShort(crc);
            this._modbusConnection.beginWrite();
            byte[] bytes = this._baos.toByteArray();
            String hex = HexUtils.bytesToHex(bytes, 0, bytes.length);
            this._log.info("<--  " + hex);
            this._modbusConnection.endWrite(bytes, 0, bytes.length);
        }
        catch (IOException ex) {
            this._log.error(ex);
            ex.printStackTrace();
            this._modbusConnection.endWrite(-1);
        }
    }

    public ModbusPdu read() {
        try {
            int slaveId = this._inputStream.read();
            System.out.println("slaveId: " + slaveId);
            int function = this._inputStream.read();
            System.out.println("function: " + function);
            ModbusPdu pdu = null;
            switch (function) {
                case 3: {
                    short address = this._dataInputStream.readShort();
                    System.out.println("address: " + address);
                    short quantity = this._dataInputStream.readShort();
                    System.out.println("quantity: " + quantity);
                    pdu = new ReadHoldingRegisters(address, quantity);
                    break;
                }
                case 4: {
                    short address = this._dataInputStream.readShort();
                    System.out.println("address: " + address);
                    short quantity = this._dataInputStream.readShort();
                    System.out.println("quantity: " + quantity);
                    pdu = new ReadInputRegisters(address, quantity);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown PDU function");
                }
            }
            short crc = this._dataInputStream.readShort();
            System.out.println("crc: " + Integer.toHexString(crc));
            return pdu;
        }
        catch (Exception ex) {
            this._log.error("error reading modbus response", ex);
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void read(ModbusPdu pdu) {
        try {
            this._inputStream = this._modbusConnection.getInputStream();
            byte[] inbuf = new byte[512];
            this._baos.reset();
            long timeout = JANOS.uptimeMillis() + 5000L;
            long totalBytes = 0L;
            while (JANOS.uptimeMillis() < timeout) {
                int bytesRead = this._inputStream.read(inbuf, 0, inbuf.length);
                this._log.debug("read(pdu): " + bytesRead + "," + (totalBytes += (long)bytesRead));
                this._baos.write(inbuf, 0, bytesRead);
                if (0 != this._inputStream.available() || this._baos.size() <= 4) continue;
                byte[] bytes = this._baos.toByteArray();
                short crc2 = ArrayUtils.getShort((byte[])bytes, (int)(bytes.length - 2));
                int calculatedCrc2 = JANOS.CRC16((byte[])bytes, (int)0, (int)(bytes.length - 2), (int)65535);
                if ((calculatedCrc2 = (int)ArrayUtils.swapEndian((short)((short)calculatedCrc2))) != crc2) continue;
                break;
            }
            byte[] inBytes = this._baos.toByteArray();
            String hex = HexUtils.bytesToHex(inBytes, 0, inBytes.length);
            this._log.info(" --> " + hex);
            byte slaveId = inBytes[0];
            byte functionCode = inBytes[1];
            if ((functionCode & 0x80) == 0) {
                byte[] data = new byte[inBytes.length - 4];
                ArrayUtils.arraycopy((Object)inBytes, (int)2, (Object)data, (int)0, (int)data.length);
                pdu.setResponse(data);
            } else {
                byte errorCode = inBytes[2];
                System.out.println("errorCode: " + errorCode);
            }
            short crc = ArrayUtils.getShort((byte[])inBytes, (int)(inBytes.length - 2));
            int calculatedCrc = JANOS.CRC16((byte[])inBytes, (int)0, (int)(inBytes.length - 2), (int)65535);
            calculatedCrc = ArrayUtils.swapEndian((short)((short)calculatedCrc));
            if (calculatedCrc != crc) {
                this._log.warn("calculatedCrc: " + Integer.toHexString(calculatedCrc) + ", crc: " + Integer.toHexString(crc));
                throw new Exception("Bad CRC Check");
            }
        }
        catch (Exception ex) {
            byte[] inBytes = this._baos.toByteArray();
            String hex = HexUtils.bytesToHex(inBytes, 0, inBytes.length);
            this._log.warn("< " + hex);
            this._log.error(ex);
            ex.printStackTrace();
        }
    }
}

