/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.protocols.modbus.protocols;

import com.integ.janoslib.protocols.modbus.connections.ModbusConnection;
import com.integ.janoslib.protocols.modbus.functions.ModbusPdu;
import com.integ.janoslib.protocols.modbus.protocols.ModbusProtocol;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ModbusAsciiProtocol
extends ModbusProtocol {
    private final ModbusConnection _modbusConnection;
    private final int _slaveId;
    private InputStream _inputStream = null;
    private OutputStream _outputStream = null;
    private DataOutputStream _dataOutputStream;
    private final ByteArrayOutputStream _baos = new ByteArrayOutputStream();
    private final DataOutputStream _dos = new DataOutputStream(this._baos);

    public ModbusAsciiProtocol(ModbusConnection modbusConnection, int slaveId) {
        this._modbusConnection = modbusConnection;
        this._slaveId = slaveId;
    }

    @Override
    public void write(ModbusPdu pdu) {
        try {
            OutputStream outputStream = this._modbusConnection.getOutputStream();
            if (this._outputStream != outputStream) {
                this._outputStream = outputStream;
                this._dataOutputStream = new DataOutputStream(outputStream);
            }
            this._baos.reset();
            this._dos.writeByte(this._slaveId);
            pdu.pack(this._dos);
            int lrc = this.getLrc(this._baos.toByteArray(), 0, this._baos.size());
            this._dos.writeByte(lrc);
            String r = HexUtils.bytesToHex(this._baos.toByteArray(), 0, this._baos.size());
            this._baos.reset();
            this._dos.writeByte(58);
            this._dos.write(r.getBytes());
            this._dos.writeByte(13);
            this._dos.writeByte(10);
            this._modbusConnection.beginWrite();
            byte[] bytes = this._baos.toByteArray();
            String hex = new String(bytes, 0, bytes.length - 2);
            this._log.info("<--  " + hex);
            this._modbusConnection.endWrite(bytes, 0, bytes.length);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this._modbusConnection.endWrite(-1);
        }
    }

    @Override
    public void read(ModbusPdu pdu) {
        try {
            this._inputStream = this._modbusConnection.getInputStream();
            this._baos.reset();
            boolean crlfReceived = false;
            long timeout = JANOS.uptimeMillis() + 5000L;
            while (JANOS.uptimeMillis() < timeout) {
                int b = this._inputStream.read();
                this._baos.write(b);
                if (!crlfReceived && 13 == b) {
                    crlfReceived = true;
                }
                if (!crlfReceived || 10 != b) continue;
                break;
            }
            byte[] inBytes = this._baos.toByteArray();
            String asciiString = new String(inBytes, 0, inBytes.length - 2);
            this._log.info(" --> " + asciiString);
            byte[] bytes = HexUtils.hexToBytes(asciiString, 1, asciiString.length() - 1);
            int lrc = bytes[bytes.length - 1] & 0xFF;
            int calculatedLrc = this.getLrc(bytes, 0, bytes.length - 1);
            if (calculatedLrc != lrc) {
                System.out.println("calculatedLrc: " + calculatedLrc + ", expected Lrc: " + lrc);
                throw new Exception("Bad LRC Check");
            }
            byte lengthToFollow = bytes[2];
            byte[] data = new byte[lengthToFollow + 2];
            ArrayUtils.arraycopy((Object)bytes, (int)3, (Object)data, (int)2, (int)lengthToFollow);
            pdu.setResponse(data);
        }
        catch (Exception ex) {
            AppLog.error("error reading modbus ascii pdu", ex);
        }
    }

    public int getLrc(byte[] bytes, int offset, int length) {
        int lrc = 0;
        for (int i = 0; i < length; ++i) {
            lrc += bytes[offset + i];
        }
        lrc = (lrc ^ 0xFF) + 1 & 0xFF;
        return lrc;
    }
}

