/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.protocols.modbus.connections;

import com.integ.janoslib.protocols.modbus.connections.ModbusConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class TcpModbusConnection
extends ModbusConnection {
    private final String _ipAddress;
    private final int _port;
    private final int _unitId;
    private Socket _socket = null;

    public TcpModbusConnection(String ipAddress, int port, int unitId) {
        this._ipAddress = ipAddress;
        this._port = port;
        this._unitId = unitId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this._socket.getOutputStream();
    }

    @Override
    public void beginWrite() {
        this.ensureConnection();
    }

    @Override
    public void endWrite(int bytesWritten) {
        if (bytesWritten < 0) {
            this.closeConnection();
        }
    }

    private void ensureConnection() {
        if (this._socket == null) {
            try {
                System.out.println("new modbus connection to " + this._ipAddress + ":" + this._port);
                this._socket = new Socket(this._ipAddress, this._port);
                this._socket.setSoTimeout(5000);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.closeConnection();
            }
        }
    }

    @Override
    public void closeConnection() {
        if (this._socket != null) {
            try {
                System.out.println("closing connection");
                this._socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this._socket = null;
            }
        }
    }

    @Override
    public boolean isConnected() {
        return null != this._socket;
    }
}

