/*
 * Decompiled with CFR 0.152.
 */
package com.integ.modbustomqtt;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.janoslib.protocols.modbus.functions.ModbusPdu;
import com.integ.janoslib.protocols.modbus.functions.ReadCoils;
import com.integ.janoslib.protocols.modbus.functions.ReadDiscreteInputs;
import com.integ.janoslib.protocols.modbus.functions.ReadHoldingRegisters;
import com.integ.janoslib.protocols.modbus.functions.ReadInputRegisters;
import com.integ.modbustomqtt.ApplicationSystemMessage;
import com.integ.modbustomqtt.ModbusSlave;
import com.integ.modbustomqtt.MqttPublishSystemMessage;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.util.Json;

public class ModbusDataTag {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM-dd HH:mm:ss");
    private final ModbusSlave _modbusSlaveParent;
    private final String _tagId;
    private final String _tagName;
    private final int _functionCode;
    private final int _address;
    private final String _dataType;
    private final int _scanRate;
    private final float _tolerance;
    private final int _quantity;
    private long _nextScanTime = System.currentTimeMillis();
    private String _status = "Unknown";
    private Object _value;
    private int _updateCount = 0;
    private long _lastUpdateTime = -1L;

    public ModbusDataTag(ModbusSlave modbusSlaveParent, Json tagJson) {
        this._modbusSlaveParent = modbusSlaveParent;
        System.out.println("tagJson: " + tagJson);
        this._tagId = tagJson.getString("Id");
        this._tagName = tagJson.getString("TagName");
        int address = Integer.valueOf(tagJson.getString("Address"));
        this._functionCode = address / 100000;
        this._address = address % 100000;
        this._dataType = tagJson.getString("DataType");
        switch (this._dataType.toLowerCase()) {
            case "short": {
                this._quantity = 2;
                break;
            }
            case "int": 
            case "float": {
                this._quantity = 4;
                break;
            }
            case "long": 
            case "double": {
                this._quantity = 8;
                break;
            }
            default: {
                this._quantity = 1;
            }
        }
        this._scanRate = tagJson.getInt("ScanRate");
        this._tolerance = tagJson.getFloat("Tolerance");
    }

    public String getTagName() {
        return this._tagName;
    }

    public long getNextScanTime() {
        return this._nextScanTime;
    }

    public void updateNextScanTime() {
        if (0L == this._nextScanTime) {
            this._nextScanTime = System.currentTimeMillis();
        }
        while (System.currentTimeMillis() >= this._nextScanTime) {
            this._nextScanTime += (long)this._scanRate;
        }
    }

    public void readTag() {
        long elapsed;
        long start = System.currentTimeMillis();
        boolean updated = false;
        String status = "Not Connected";
        try {
            for (int attempt = 0; attempt < this._modbusSlaveParent.getRetries(); ++attempt) {
                if (0 < attempt) {
                    System.out.println(this._modbusSlaveParent.getSlaveName() + " attempt: " + attempt);
                }
                byte[] response = null;
                response = this.performRequest();
                if (null != response) {
                    int byteCount = response.length;
                    Number value = null;
                    switch (this._dataType.toLowerCase()) {
                        case "byte": {
                            value = response[2] & 0xFF;
                            break;
                        }
                        case "short": {
                            value = ArrayUtils.getShort((byte[])response, (int)2) & 0xFFFF;
                            break;
                        }
                        case "int": {
                            value = ArrayUtils.getInt((byte[])response, (int)2) & 0xFFFFFFFF;
                            break;
                        }
                        case "long": {
                            value = ArrayUtils.getLong((byte[])response, (int)2);
                            break;
                        }
                        case "float": {
                            int intBits = ArrayUtils.getInt((byte[])response, (int)2);
                            value = Float.valueOf(Float.intBitsToFloat(intBits));
                            break;
                        }
                        case "double": {
                            long longBits = ArrayUtils.getLong((byte[])response, (int)2);
                            value = Double.longBitsToDouble(longBits);
                        }
                    }
                    boolean changed = this.hasValueChanged(value);
                    updated |= changed;
                    if (changed) {
                        ++this._updateCount;
                        this._lastUpdateTime = System.currentTimeMillis();
                        this._value = value;
                        String topicName = String.format("jnior/%d/status/modbus/%s/%s", JANOS.getSerialNumber(), StringUtils.replaceAll(this._modbusSlaveParent.getSlaveName().toLowerCase(), " ", ""), StringUtils.replaceAll(this._tagName.toLowerCase(), " ", ""));
                        ApplicationSystemMessage msg = new MqttPublishSystemMessage(topicName, String.valueOf(this._value)).build();
                        MessagePumpEngine.postMessage(msg);
                    }
                    status = "Good";
                    break;
                }
                status = "Timeout";
                this._modbusSlaveParent.getModbusConnection().closeConnection();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._modbusSlaveParent.getLog().error(this._modbusSlaveParent.getSlaveName(), ex);
            status = "Error";
        }
        if (updated |= !this._status.equals(status)) {
            this._status = status;
            this.sendUpdate();
        }
        if (500L < (elapsed = System.currentTimeMillis() - start)) {
            this._modbusSlaveParent.getLog().info(String.format("poll took %.2f seconds", (double)elapsed / 1000.0));
        }
    }

    private byte[] performRequest() {
        int address = this._address;
        String dataTagInfo = String.format("_functionCode: %d, address: %d, quantity: %d", this._functionCode, address, this._quantity);
        ModbusPdu pdu = null;
        switch (this._functionCode) {
            case 0: {
                pdu = new ReadCoils(address, this._quantity);
                break;
            }
            case 1: {
                pdu = new ReadDiscreteInputs(address, this._quantity);
                break;
            }
            case 3: {
                pdu = new ReadHoldingRegisters(address, this._quantity / 2);
                break;
            }
            case 4: {
                pdu = new ReadInputRegisters(address, this._quantity / 2);
                break;
            }
        }
        if (null != pdu) {
            try {
                this._modbusSlaveParent.getModbusProtocol().write(pdu);
                this._modbusSlaveParent.getModbusProtocol().read(pdu);
                byte[] bytes = pdu.getResponse();
                if (0 != bytes.length) {
                    return bytes;
                }
                this._modbusSlaveParent.getLog().error("zero bytes returned");
            }
            catch (Exception ex) {
                this._modbusSlaveParent.getLog().error("Error during MODBUS query for " + dataTagInfo);
            }
        }
        return null;
    }

    public boolean hasValueChanged(Number newValue) {
        if (newValue instanceof Float && Float.isNaN(newValue.floatValue())) {
            return false;
        }
        if (newValue instanceof Double && Double.isNaN(newValue.doubleValue())) {
            return false;
        }
        boolean hasChanged = false;
        Number savedValue = (Number)this._value;
        if (null == savedValue) {
            hasChanged = true;
        }
        if (!hasChanged && !newValue.equals(savedValue)) {
            if (0.0f != this._tolerance) {
                if ((double)this._tolerance < Math.abs(newValue.doubleValue() - savedValue.doubleValue())) {
                    hasChanged = true;
                } else {
                    this._modbusSlaveParent.getLog().info(String.format("%s has changed from %s to %s but is still within the tolerance of  %s", this._tagName, String.valueOf(this._value), String.valueOf(newValue), String.valueOf(this._tolerance)));
                }
            } else {
                hasChanged = true;
            }
        }
        if (hasChanged) {
            this._modbusSlaveParent.getLog().info(String.format("%s has changed from %s to %s", this._tagName, String.valueOf(this._value), String.valueOf(newValue)));
        }
        return hasChanged;
    }

    public void sendUpdate() {
        ApplicationSystemMessage msg = new ApplicationSystemMessage("tag-read").put("SlaveName", this._modbusSlaveParent.getSlaveName()).put("TagName", this._tagName).put("TagId", this._tagId).put("Status", this._status).put("Value", String.valueOf(this._value)).put("UpdateCount", this._updateCount).put("LastUpdateTime", this._lastUpdateTime / 1000L).build();
        MessagePumpEngine.postMessage(msg);
    }
}

