/*
 * Decompiled with CFR 0.152.
 */
package com.integ.modbustomqtt;

import com.integ.modbustomqtt.ModbusDataTag;
import com.integ.modbustomqtt.ModbusSlave;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;

public class DataTagPollEngine
implements Runnable {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM-dd-yyyy HH:mm:ss");
    private final ModbusSlave _modbusSlave;
    private Thread _thread = null;
    private boolean _quit = false;

    public DataTagPollEngine(ModbusSlave modbusSlave) {
        this._modbusSlave = modbusSlave;
    }

    public void start() {
        if (null == this._thread) {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName() + ":" + this._modbusSlave.getSlaveName());
            this._thread.setDaemon(true);
            this._thread.start();
        }
    }

    @Override
    public void run() {
        try {
            ModbusDataTag[] modbusDataTags;
            this._modbusSlave.getLog().info("start scanning tags...");
            long nextScanTime = Long.MAX_VALUE;
            for (ModbusDataTag modbusDataTag : modbusDataTags = this._modbusSlave.getDataTags()) {
                if (modbusDataTag.getNextScanTime() >= nextScanTime) continue;
                nextScanTime = modbusDataTag.getNextScanTime();
            }
            while (!this._quit) {
                int sleepDuration = (int)(nextScanTime - System.currentTimeMillis());
                if (0 < sleepDuration) {
                    Thread.sleep(sleepDuration);
                }
                modbusDataTags = this._modbusSlave.getDataTags();
                long now = System.currentTimeMillis();
                for (ModbusDataTag modbusDataTag : modbusDataTags) {
                    if (modbusDataTag.getNextScanTime() >= now) continue;
                    modbusDataTag.readTag();
                    modbusDataTag.updateNextScanTime();
                    if (modbusDataTag.getNextScanTime() >= nextScanTime) continue;
                    nextScanTime = modbusDataTag.getNextScanTime();
                }
                nextScanTime = Long.MAX_VALUE;
                for (ModbusDataTag modbusDataTag : modbusDataTags) {
                    if (modbusDataTag.getNextScanTime() >= nextScanTime) continue;
                    nextScanTime = modbusDataTag.getNextScanTime();
                }
            }
        }
        catch (InterruptedException ex) {
            this._modbusSlave.getLog().error("scanning stopped", ex);
        }
    }

    void stop() throws InterruptedException {
        AppLog.info("stopping scan for " + this._modbusSlave.getSlaveName());
        this._modbusSlave.getLog().info("stop scanning");
        this._quit = true;
        this._thread.interrupt();
        this._thread.join();
    }
}

