/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.Constants;
import com.integ.supporter.RollingLog;
import com.integ.supporter.ui.ProgressPercentComplete;
import com.integ.supporter.ui.TextPaneLog;
import com.integ.supporter.updater.UpdateProgressCollection;
import com.integ.supporter.updater.UpdateProjectExecutor;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateProjectListener;
import com.integ.supporter.updater.steps.ProjectStep;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;

public class JniorUpdateTab
extends JPanel
implements ProgressPercentComplete,
UpdateProjectListener {
    private static final SimpleDateFormat FOLDER_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private final UpdateProjectFile _updateProjectFile;
    private final JniorInfo _jniorInfo;
    private final ArrayList<ProjectStep> _steps;
    private final String _folder;
    private Logger _logger = Logger.getGlobal();
    private UpdateProjectExecutor _updateProjectExecutor;
    private UpdateProjectListener _updateProjectListener;
    private double _percentComplete = 0.0;
    private final TextPaneLog _textPaneLog;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public JniorUpdateTab(UpdateProjectFile updateProjectFile, JniorInfo jniorInfo, ArrayList<ProjectStep> steps) throws IOException {
        this.initComponents();
        this._updateProjectFile = updateProjectFile;
        this._jniorInfo = jniorInfo;
        this._steps = steps;
        this._folder = String.format("%s/%s_%s", Constants.TEMP_DIRECTORY, this._jniorInfo.getSerialNumber(), FOLDER_DATE_FORMAT.format(new Date()));
        this._logger = RollingLog.getLogger(String.format("%s/Update_%s", new File(Constants.UPDATES_LOGS_DIRECTORY).getName(), jniorInfo.IpAddress));
        this._textPaneLog = new TextPaneLog(this.jTextPane1);
        this._logger.addHandler(this._textPaneLog);
    }

    public void setListener(UpdateProjectListener updateProjectListener) {
        this._updateProjectListener = updateProjectListener;
    }

    public JniorInfo getJniorInfo() {
        return this._jniorInfo;
    }

    public UpdateProjectExecutor getUpdateProjectExecutor() {
        return this._updateProjectExecutor;
    }

    public UpdateProjectExecutor publish() {
        try {
            this._logger.info(String.format("Publish %s", this._updateProjectFile.getFilePath()));
            this._updateProjectExecutor = new UpdateProjectExecutor(this._updateProjectFile, this._jniorInfo, this._steps);
            this._updateProjectExecutor.setLogger(this._logger);
            this._updateProjectExecutor.setListener(this);
            this._updateProjectExecutor.start();
            UpdateProgressCollection.getInstance().addBackgroundAction(this._updateProjectExecutor);
        }
        catch (SecurityException ex) {
            this._logger.severe(ex.getMessage());
        }
        return this._updateProjectExecutor;
    }

    @Override
    public double getPercentComplete() {
        return this._percentComplete;
    }

    public boolean isComplete() {
        return 100.0 <= this._percentComplete;
    }

    public boolean isRunning() {
        return null != this._updateProjectExecutor && this._updateProjectExecutor.getResult().isInProgress();
    }

    public void abort() {
        this._logger.info("Aborting " + this._updateProjectFile.getFilePath());
        this._updateProjectExecutor.abort();
    }

    @Override
    public void loginFailed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateProjectStepResult(ProjectStep projectStep, boolean result, int index, int total) {
        if (result) {
            this._percentComplete = (double)index / (double)total * 100.0;
            JTabbedPane parentTabPane = (JTabbedPane)JniorUpdateTab.super.getParent();
            parentTabPane.repaint();
        }
    }

    @Override
    public void updateProjectResult(UpdateProjectExecutor updateProjectExecutor, boolean result) {
        if (result) {
            this.setTabBackground(Color.decode("#c0ffc0"));
        } else if (!updateProjectExecutor.getResult().wasAborted()) {
            this.setTabBackground(Color.decode("#ffc0c0"));
        } else {
            this.setTabBackground(Color.decode("#ffffc0"));
        }
        if (null != this._updateProjectListener) {
            this._updateProjectListener.updateProjectResult(updateProjectExecutor, result);
        }
        this._logger.removeHandler(this._textPaneLog);
    }

    public void setTabBackground(Color color) {
        int index;
        JTabbedPane tabbedPane = (JTabbedPane)this.getParent();
        if (null != tabbedPane && -1 != (index = tabbedPane.indexOfComponent(this))) {
            tabbedPane.setBackgroundAt(index, color);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

