/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon.menus;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.net.beacon.commands.QueryCommand;
import com.integ.supporter.JniorItem;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.BeaconTableColumnModel;
import com.integ.supporter.beacon.dialogs.SelectBeaconColumnsDialog;
import com.integ.supporter.ui.menus.MenuAdapter;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.MenuEvent;

public class BeaconMenu
extends JMenu {
    private JMenuItem _menuQuery;

    public BeaconMenu() {
        super("Beacon");
        this.createMenu();
    }

    private void createMenu() {
        super.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean selectedJniors = 0 < BeaconTab.getInstance().selectedJniorCount();
                BeaconMenu.this._menuQuery.setEnabled(selectedJniors);
            }
        });
        this.addQueryAll();
        this.addQuery();
        super.addSeparator();
        this.addSelectColumnsMenuItem();
        this.addShowPreviouslySeen();
        this.addJniorMenuItem();
    }

    private void addQueryAll() {
        JMenuItem menuItem = new JMenuItem("Query All");
        menuItem.addActionListener(e -> BeaconTab.getInstance().queryAll());
        super.add(menuItem);
    }

    private void addQuery() {
        this._menuQuery = new JMenuItem("Query");
        this._menuQuery.addActionListener(e -> {
            JniorItem jniorItem = BeaconTab.getInstance().getSelectedJniorItem();
            JniorInfo jniorInfo = jniorItem.getJniorInfo();
            Beacon.getInstance().broadcastCommand(new QueryCommand(jniorInfo.getSerialNumber()));
        });
        super.add(this._menuQuery);
    }

    private void addSelectColumnsMenuItem() {
        JMenuItem menuItem = new JMenuItem("Select Columns");
        menuItem.addActionListener(e -> {
            JTable table = BeaconTab.getInstance().getTable();
            BeaconTableColumnModel beaconTableColumnModel = (BeaconTableColumnModel)table.getColumnModel();
            SelectBeaconColumnsDialog showBeaconColumnsDialog = new SelectBeaconColumnsDialog(null, true);
            showBeaconColumnsDialog.setColumnModel(beaconTableColumnModel);
            showBeaconColumnsDialog.setVisible(true);
            table.getTableHeader().revalidate();
        });
        super.add(menuItem);
    }

    private void addShowPreviouslySeen() {
        JMenuItem menuItem = new JMenuItem("Show Previously Seen Units");
        menuItem.addActionListener(e -> BeaconTab.getInstance().showPreviouslySeen());
        super.add(menuItem);
    }

    private void addJniorMenuItem() {
        JMenuItem menuItem = new JMenuItem("Add JNIOR to the list");
        menuItem.addActionListener(e -> {});
        super.add(menuItem);
    }
}

