/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.beacon.BeaconNotificationPane;
import com.integ.supporter.snapshot.SnapshotProgressCollection;
import com.integ.supporter.updater.UpdateProgressCollection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class StatusBar
extends JPanel {
    private int _activeUpdateProjectCount = 0;
    private int _activeSnapshotCount = 0;
    private JniorInfo _backupJniorInProgress = null;
    private JLabel actionsInProgressLabel;
    private BeaconNotificationPane beaconNotificationPane1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel ntpStatusLabel;
    private JLabel publicIpAddressLabel;
    private JLabel statusLabel;

    public StatusBar() {
        this.initComponents();
        this.ntpStatusLabel.setVisible(false);
        ChangeListener changeListener = e -> {
            this._activeUpdateProjectCount = UpdateProgressCollection.getInstance().getActiveCount();
            this._activeSnapshotCount = SnapshotProgressCollection.getInstance().getActiveCount();
            this.upadateInPorgressStatus();
        };
        UpdateProgressCollection.getInstance().addChangeListener(changeListener);
        SnapshotProgressCollection.getInstance().addChangeListener(changeListener);
    }

    private void upadateInPorgressStatus() {
        this.actionsInProgressLabel.setText(String.format("In Progress: Updates: %d, Snapshots: %d", this._activeUpdateProjectCount, this._activeSnapshotCount));
    }

    private void initComponents() {
        this.beaconNotificationPane1 = new BeaconNotificationPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.actionsInProgressLabel = new JLabel();
        this.ntpStatusLabel = new JLabel();
        this.publicIpAddressLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.statusLabel = new JLabel();
        this.setBackground(new Color(255, 153, 153));
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(228, 228, 228)));
        this.setLayout(new BorderLayout());
        this.beaconNotificationPane1.setPreferredSize(new Dimension(76, 33));
        this.add((Component)this.beaconNotificationPane1, "West");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(1, 15, 8));
        this.actionsInProgressLabel.setText("Nothing In Progress");
        this.jPanel2.add(this.actionsInProgressLabel);
        this.ntpStatusLabel.setText("NTP Status: fetching...");
        this.jPanel2.add(this.ntpStatusLabel);
        this.publicIpAddressLabel.setText("Public IP: fetching...");
        this.jPanel2.add(this.publicIpAddressLabel);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.add((Component)this.jPanel1, "East");
        this.jPanel3.setLayout(new FlowLayout(0, 5, 8));
        this.jPanel3.add(this.statusLabel);
        this.statusLabel.getAccessibleContext().setAccessibleName("status");
        this.add((Component)this.jPanel3, "Center");
    }

    public void setStatusText(String text) {
        this.statusLabel.setText(text);
    }

    public void setNTPStatus(String ntpStatusString) {
        this.ntpStatusLabel.setText(String.format("NTP Status: %s", ntpStatusString));
    }

    public void setPublicIpAddress(String ipAddressString) {
        this.publicIpAddressLabel.setText(String.format("Public IP Address: %s", ipAddressString));
    }
}

