/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.toasts;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.integ.supporter.ui.ColorConstants;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;

public class OptionPaneToast
extends JOptionPane {
    public static final int SUCCESS_MESSAGE = 4;
    private static final float SCALE = 0.05859375f;
    private static final FlatSVGIcon SUCCESS_ICON = new FlatSVGIcon("resources/success.svg", 0.05859375f);
    protected int _result = 1;
    protected int _autoHideDuration = -1;
    private boolean _modal = false;

    public OptionPaneToast() {
        this.setMessageType(1);
        this.setColor(ColorConstants.NOTIFICATION_COLOR);
        super.setBackground(Color.WHITE);
    }

    public OptionPaneToast(Object message) {
        this(message, 1);
    }

    public OptionPaneToast(Object message, int messageType) {
        super(message);
        this.setColor(ColorConstants.NOTIFICATION_COLOR);
        this.setMessageType(messageType);
    }

    @Override
    public void setMessageType(int messageType) {
        if (-1 == messageType) {
            messageType = 1;
        }
        if (4 != messageType) {
            super.setMessageType(messageType);
        }
        super.setBackground(Color.WHITE);
        Color color = ColorConstants.NOTIFICATION_COLOR;
        if (2 == messageType) {
            super.setBackground(Color.decode("#fcedd9"));
            color = ColorConstants.WARNING_COLOR;
        } else if (0 == messageType) {
            super.setBackground(Color.decode("#fdecec"));
            color = ColorConstants.ERROR_COLOR;
        } else if (4 == messageType) {
            super.setIcon(SUCCESS_ICON);
            super.setBackground(Color.decode("#E2F3E2"));
            color = ColorConstants.SUCCESS_COLOR;
        }
        this.setColor(color);
    }

    private void setColor(Color color) {
        super.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 4, 1, 1, color), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
    }

    public boolean getModal() {
        return this._modal;
    }

    public void setModal(boolean modal) {
        this._modal = modal;
    }

    public int getAutoHideDuration() {
        return this._autoHideDuration;
    }

    public void setAutoHideDuration(int autoHideDuration) {
        this._autoHideDuration = autoHideDuration;
    }

    public int getResult() {
        return this._result;
    }

    static {
        FlatSVGIcon.ColorFilter grayColorFilter = new FlatSVGIcon.ColorFilter();
        grayColorFilter.add(Color.BLACK, ColorConstants.SUCCESS_COLOR);
        SUCCESS_ICON.setColorFilter(grayColorFilter);
    }
}

