/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.devices;

import java.util.LinkedHashMap;

public class CinemaDevice {
    protected String _name;
    private final LinkedHashMap<String, String> _actionNameValueMap = new LinkedHashMap();
    private final LinkedHashMap<String, String> _actionNameHelpMap = new LinkedHashMap();
    private final LinkedHashMap<String, Boolean> _actionValueRequiresDataMap = new LinkedHashMap();

    protected CinemaDevice(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public CinemaDevice setName(String name) {
        this._name = name;
        return this;
    }

    protected void addAction(String name, String value, String description) {
        this.addAction(name, value, description, false);
    }

    protected void addAction(String name, String value, String description, boolean requiresData) {
        this._actionNameValueMap.put(name, value);
        this._actionNameHelpMap.put(name, description);
        this._actionValueRequiresDataMap.put(value, requiresData);
    }

    public final LinkedHashMap<String, String> getActionsArray() {
        return this._actionNameValueMap;
    }

    public String getActionByValue(String value) {
        for (String key : this._actionNameValueMap.keySet()) {
            String actionValue = this._actionNameValueMap.get(key);
            if (!actionValue.equalsIgnoreCase(value)) continue;
            return key;
        }
        return "";
    }

    public final String getHelpForAction(String action) {
        return this._actionNameHelpMap.get(action);
    }

    public boolean requiresData(String actionValue) {
        if (this._actionValueRequiresDataMap.containsKey(actionValue)) {
            return this._actionValueRequiresDataMap.get(actionValue);
        }
        return false;
    }

    public String toString() {
        return this._name;
    }
}

