/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.protocols.events.ConnectionEvent;
import com.integ.supporter.BackgroundAction;
import com.integ.supporter.Constants;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.JniorControlConnectionAuthenticationEvent;
import com.integ.supporter.JniorControlConnectionAuthenticationListener;
import com.integ.supporter.JniorControlConnectionListener;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.dialogs.LoginDialog;
import java.awt.Desktop;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class DoGetNetworkCapture
extends BackgroundAction {
    private JniorControlConnection _jniorControlConnection;
    private int authenticationFailedOccurances = 0;
    private boolean _cancel = false;

    public DoGetNetworkCapture(JniorInfo jniorInfo) {
        super(jniorInfo);
    }

    @Override
    public String getTitle() {
        return "Get Network Capture for " + super.getJniorInfo().toString();
    }

    public void execute() {
        super.start();
    }

    @Override
    public void run() {
        super.getResult().start();
        if (3 == super.getJniorInfo().getSeries()) {
            super.update("Network Capture is Not Available on Series 3 Units.");
            super.getResult().complete();
            return;
        }
        super.update("Establishing connection to retreive Network Capture...");
        this._jniorControlConnection = JniorControlConnection.getFor(super.getJniorInfo(), Logger.getGlobal());
        this._jniorControlConnection.addConnectionListener(new JniorControlConnectionListener(){

            @Override
            public void onConnected(ConnectionEvent event) {
            }

            @Override
            public void onClosed(ConnectionEvent event) {
                DoGetNetworkCapture.this.update("Connection Closed");
                DoGetNetworkCapture.super.getResult().complete();
            }

            @Override
            public void onError(ConnectionEvent event) {
            }
        });
        this._jniorControlConnection.addAuthenticationListener(new JniorControlConnectionAuthenticationListener(){

            @Override
            public void onAuthenticationSuccess(JniorControlConnectionAuthenticationEvent event) {
                System.out.println("Get Network Capture Logged In");
            }

            @Override
            public void onAuthenticationFailed(JniorControlConnectionAuthenticationEvent event) {
                try {
                    ++DoGetNetworkCapture.this.authenticationFailedOccurances;
                    if (1 < DoGetNetworkCapture.this.authenticationFailedOccurances) {
                        LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
                        loginDialog.setDescription("Get Network Capture for " + DoGetNetworkCapture.this.getJniorInfo().IpAddress);
                        loginDialog.centerParent();
                        loginDialog.setVisible(true);
                        if (loginDialog.getResult() == 1) {
                            DoGetNetworkCapture.this.getJniorInfo().Username = loginDialog.getUsername();
                            DoGetNetworkCapture.this.getJniorInfo().Password = loginDialog.getPassword();
                        } else {
                            try {
                                DoGetNetworkCapture.this._cancel = true;
                                DoGetNetworkCapture.this._jniorControlConnection.disconnect();
                                return;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    DoGetNetworkCapture.this._jniorControlConnection.login(DoGetNetworkCapture.this.getJniorInfo().Username, DoGetNetworkCapture.this.getJniorInfo().Password);
                }
                catch (LoginFailedException ex) {
                    NotificationCollection.addError("Error providing custom credentials for " + DoGetNetworkCapture.this._jniorControlConnection.toString(), ex);
                }
            }
        });
        try {
            this._jniorControlConnection.connect();
            if (!this._cancel) {
                super.update("Executing netstat -c...");
                this._jniorControlConnection.exec("netstat -c");
                File networkCapturesTempDirectory = new File(Constants.NETWORK_CAPTURES_DIRECTORY);
                if (!networkCapturesTempDirectory.exists()) {
                    networkCapturesTempDirectory.mkdir();
                }
                super.update("Downloading capture...");
                String networkFilename = String.format("network_%s.pcapng", super.getJniorInfo().Hostname);
                File tempNetworkFile = new File(networkCapturesTempDirectory.getPath() + File.separator + networkFilename);
                FileOutputStream out = new FileOutputStream(tempNetworkFile.getPath());
                this._jniorControlConnection.retrieveFile("/temp/network.pcapng", out);
                super.getJniorInfo().AttentionInfo = (short)(super.getJniorInfo().AttentionInfo & 0xEF0);
                super.getResult().complete();
                super.update("Network Capture Downloaded");
                if (Constants.IS_WINDOWS) {
                    Runtime.getRuntime().exec("explorer.exe \"" + tempNetworkFile.getPath() + "\"");
                } else {
                    Desktop desktop = Desktop.getDesktop();
                    desktop.open(networkCapturesTempDirectory);
                }
            } else {
                super.update("User Cancelled");
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Unable to download the Network Capture", ex);
        }
        super.getResult().complete();
    }
}

