/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.menus;

import com.formdev.flatlaf.extras.components.FlatButton;
import com.integ.supporter.CollectionModifiedEvent;
import com.integ.supporter.Constants;
import com.integ.supporter.Notification;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.OpenTelnetConsole;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.WebUrlLauncher;
import com.integ.supporter.cinema.CinemaMenu;
import com.integ.supporter.config.GeneralConfig;
import com.integ.supporter.ui.CollectionModifiedAdapter;
import com.integ.supporter.ui.ColorConstants;
import com.integ.supporter.ui.FlatHoverButton;
import com.integ.supporter.ui.NotificationButton;
import com.integ.supporter.ui.dialogs.AboutDialog;
import com.integ.supporter.ui.dialogs.SettingsDialog;
import com.integ.supporter.ui.menus.FileMenu;
import com.integ.supporter.ui.menus.HelpMenu;
import com.integ.supporter.ui.menus.MainPopupMenu;
import com.integ.supporter.ui.menus.OptionsMenu;
import com.integ.supporter.ui.menus.ToolsMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;

public class MainMenu
extends JMenuBar {
    public static final Logger MENU_LOGGER = RollingLog.getLogger("mainmenu");
    private static final float SCALE = 0.02734375f;

    public MainMenu() {
        this.initMenu();
        GeneralConfig.getInstance().addChangeListener(e -> {
            super.removeAll();
            this.initMenu();
            super.updateUI();
        });
    }

    private void initMenu() {
        boolean requireFullMenu = false;
        if (Constants.OS_NAME.toLowerCase().startsWith("windows")) {
            System.out.println(System.getProperty("os.version"));
            double osVersion = Double.parseDouble(System.getProperty("os.version"));
            if (10.0 > osVersion) {
                requireFullMenu = true;
            }
        }
        if (requireFullMenu || !GeneralConfig.getMainMenuUseIcons()) {
            super.add(new FileMenu());
            super.add(new OptionsMenu());
            super.add(new ToolsMenu());
            if (GeneralConfig.getShowCinemaInMainMenu()) {
                super.add(new CinemaMenu());
            }
            super.add(new HelpMenu());
        } else {
            this.addHamburger();
            this.addTerminal();
            if (GeneralConfig.getShowCinemaInMainMenu()) {
                this.addCinema();
            }
            this.addSettings();
        }
        super.add(Box.createHorizontalGlue());
        this.addNotifications();
    }

    private void addHamburger() {
        FlatHoverButton menuButton = new FlatHoverButton("Main Menu");
        menuButton.setIcon("resources/bars.svg", 0.02734375f);
        menuButton.addActionListener(e -> new MainPopupMenu().show(menuButton, 10, 10));
        this.addButton(menuButton);
    }

    private void addTerminal() {
        FlatHoverButton menuButton = new FlatHoverButton("Console");
        menuButton.setIcon("resources/terminal.svg", 0.02734375f);
        menuButton.addActionListener(e -> new Thread(){

            @Override
            public void run() {
                OpenTelnetConsole openTelnetConsole = new OpenTelnetConsole("");
                openTelnetConsole.execute();
            }
        }.start());
        this.addButton(menuButton);
    }

    private void addCinema() {
        FlatHoverButton menuButton = new FlatHoverButton("Cinema");
        menuButton.setIcon("resources/film.svg", 0.02734375f);
        menuButton.addActionListener(e -> {
            JPopupMenu popupMenu = new JPopupMenu();
            CinemaMenu cinemaMenu = new CinemaMenu();
            while (0 < cinemaMenu.getItemCount()) {
                int i = cinemaMenu.getItemCount();
                Component menuItem = cinemaMenu.getMenuComponent(0);
                popupMenu.add(menuItem);
            }
            popupMenu.show(menuButton, 10, 10);
        });
        this.addButton(menuButton);
    }

    private void addSettings() {
        try {
            FlatHoverButton button = new FlatHoverButton("Settings");
            button.setIcon("resources/gear.svg", 0.02734375f);
            button.addActionListener(e -> {
                int modifiers = e.getModifiers();
                SettingsDialog settingsDialog = new SettingsDialog((Frame)SupporterMain.getMainFrame(), true);
                if (0 != (2 & modifiers)) {
                    settingsDialog.showBetaPanels();
                }
                settingsDialog.setLocationRelativeTo(null);
                settingsDialog.setVisible(true);
            });
            this.addButton(button);
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.SEVERE, null, ex);
        }
    }

    private void addNotifications() {
        try {
            final NotificationButton _notificationButton = new NotificationButton("Notifications");
            _notificationButton.setIcon("resources/bell-open.svg", 0.02734375f);
            _notificationButton.setNotificationVisible(false);
            this.addButton(_notificationButton);
            NotificationCollection.getInstance().addCollectionListener(new CollectionModifiedAdapter(){

                @Override
                public void itemAdded(CollectionModifiedEvent e, Object item) {
                    boolean errorFound = false;
                    ArrayList<Notification> notifications = NotificationCollection.getNotifications();
                    for (Notification notification1 : notifications) {
                        if (notification1.getLevel() != 4) continue;
                        errorFound = true;
                        break;
                    }
                    _notificationButton.setNotificationVisible(!notifications.isEmpty());
                    _notificationButton.setNotificationColor(errorFound ? ColorConstants.ERROR_COLOR : ColorConstants.NOTIFICATION_COLOR);
                }

                @Override
                public void collectionModified(CollectionModifiedEvent e) {
                    _notificationButton.setIcon(!NotificationCollection.getNotifications().isEmpty() ? "resources/bell.svg" : "resources/bell-open.svg", 0.02734375f);
                    _notificationButton.setNotificationColor(!NotificationCollection.getNotifications().isEmpty() ? _notificationButton.getNotifcationColor() : Color.GRAY);
                }
            });
            _notificationButton.addActionListener(e -> SupporterMain.getMainFrame().toggleNotifications());
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.SEVERE, null, ex);
        }
    }

    private void addHelp() {
        FlatHoverButton helpButton = new FlatHoverButton("Knowledgebase");
        helpButton.setIcon("resources/circle-question.svg", 0.02734375f);
        helpButton.addActionListener(e -> WebUrlLauncher.go("https://jnior.com/jnior-supporter-overview/?kb=kb-supporttool,kb-supporter&section=getting%20started"));
        this.addButton(helpButton);
    }

    private void addContactUs() {
        try {
            FlatHoverButton button = new FlatHoverButton("Contact Us");
            button.setIcon("resources/envelope.svg", 0.02734375f);
            this.addButton(button);
            button.addActionListener(e -> WebUrlLauncher.go("https://jnior.com/contact"));
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.SEVERE, null, ex);
        }
    }

    private void addJniorDotCom() {
        try {
            FlatHoverButton button = new FlatHoverButton("Jnior.com");
            button.setIcon("resources/house-chimney.svg", 0.02734375f);
            button.setIcon("resources/globe.svg", 0.02734375f);
            this.addButton(button);
            button.addActionListener(e -> WebUrlLauncher.go("https://jnior.com"));
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.SEVERE, null, ex);
        }
    }

    private void addAbout() {
        FlatHoverButton helpButton = new FlatHoverButton();
        helpButton.setIcon("resources/info.svg", 0.02734375f);
        helpButton.addActionListener(e -> {
            AboutDialog dialog = new AboutDialog(null, true);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        });
        this.addButton(helpButton);
    }

    private void addButton(FlatHoverButton button) {
        button.setButtonType(FlatButton.ButtonType.toolBarButton);
        button.setFocusable(false);
        button.setHorizontalTextPosition(4);
        button.setVerticalTextPosition(0);
        button.setMargin(new Insets(0, 4, 0, 4));
        button.setToolTipText(button.getText());
        button.setTextEnabled(GeneralConfig.getIconsWithText());
        super.add(button);
    }
}

