/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols.jmpprotocol.helpers;

import com.integ.protocols.events.JmpProtocolMessageListener;
import com.integ.protocols.events.JmpProtocolMessageReceivedEvent;
import com.integ.protocols.jmpprotocol.JmpProtocolClient;
import com.integ.protocols.jmpprotocol.helpers.FileProgressErrorEvent;
import com.integ.protocols.jmpprotocol.helpers.FileProgressListener;
import com.integ.protocols.jmpprotocol.helpers.FileProgressNotifier;
import com.integ.protocols.jmpprotocol.helpers.FileProgressUpdatedEvent;
import com.integ.protocols.jmpprotocol.messages.FileReadMessage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import org.json.JSONObject;

public class ReadFileHelper
implements JmpProtocolMessageListener {
    private final JmpProtocolClient _jmpProtocolClient;
    private final String _remoteFilepath;
    private final FileReadMessage _fileRead;
    private final Object _fileReceiveWaitObject = new Object();
    private final ByteArrayOutputStream _fileContents = new ByteArrayOutputStream();
    private final FileProgressNotifier _fileProgressNotifier = new FileProgressNotifier();
    private int _offset = 0;
    private boolean _success;
    private Exception _error = null;

    public ReadFileHelper(JmpProtocolClient jmpProtocolConnection, String remoteFilepath) {
        this._jmpProtocolClient = jmpProtocolConnection;
        this._remoteFilepath = remoteFilepath;
        this._fileRead = new FileReadMessage(this._remoteFilepath);
    }

    public void addFileProgressListener(FileProgressListener fileProgressListener) {
        this._fileProgressNotifier.addEventListener(fileProgressListener);
    }

    public void removeFileProgressListener(FileProgressListener fileProgressListener) {
        this._fileProgressNotifier.removeEventListener(fileProgressListener);
    }

    public String getRemoterFilePath() {
        return this._remoteFilepath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(JmpProtocolMessageReceivedEvent event) {
        block14: {
            JSONObject jsonMessage = event.getJsonMessage();
            String message = jsonMessage.getString("Message");
            if ("File Read Response".equals(message)) {
                String status = jsonMessage.getString("Status");
                if ("Succeed".equalsIgnoreCase(status)) {
                    try {
                        JSONObject meta = jsonMessage.getJSONObject("Meta");
                        String hash = meta.getString("Hash");
                        if (!this._fileRead.getHash().equals(hash)) break block14;
                        String fileData = jsonMessage.getString("Data");
                        byte[] contents = Base64.getDecoder().decode(fileData);
                        this._fileContents.write(contents);
                        int numberOfBytesRead = jsonMessage.getInt("NumRead");
                        this._offset += numberOfBytesRead;
                        int fileSize = jsonMessage.getInt("Size");
                        float percent = (float)(this._fileContents.size() * 100) / (float)fileSize;
                        this._fileProgressNotifier.notifyFileProgressUpdated(new FileProgressUpdatedEvent(this, this._remoteFilepath, percent));
                        if (fileSize == this._offset) {
                            this._fileContents.close();
                            this._success = true;
                        } else if (this._offset > fileSize) {
                            throw new RuntimeException("Offset past end of file");
                        }
                        Object object = this._fileReceiveWaitObject;
                        synchronized (object) {
                            this._fileReceiveWaitObject.notifyAll();
                        }
                    }
                    catch (Exception ex) {
                        this._error = ex;
                        this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remoteFilepath, ex.getMessage()));
                    }
                } else {
                    this._error = new RuntimeException(String.format("Error reading %s: %s", this._remoteFilepath, status));
                    this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remoteFilepath, String.format("File Download Failed: %s", jsonMessage.toString())));
                    Object object = this._fileReceiveWaitObject;
                    synchronized (object) {
                        this._fileReceiveWaitObject.notifyAll();
                    }
                }
            }
        }
    }

    public ReadFileHelper setChunkSize(int limit) {
        this._fileRead.setLimit(limit);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getContents() {
        try {
            this._fileProgressNotifier.notifyFileProgressUpdated(new FileProgressUpdatedEvent(this, this._remoteFilepath, 0.0f));
            while (!this._success && null == this._error) {
                this._fileRead.setOffset(this._offset);
                this._jmpProtocolClient.send(this._fileRead, this);
                Object object = this._fileReceiveWaitObject;
                synchronized (object) {
                    this._fileReceiveWaitObject.wait(15000L);
                    System.out.println("");
                }
            }
        }
        catch (Exception ex) {
            this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remoteFilepath, ex.getMessage()));
        }
        if (!this._success) return null;
        byte[] byArray = this._fileContents.toByteArray();
        return byArray;
    }

    public boolean wasError() {
        return null != this._error;
    }

    public Exception getError() {
        return this._error;
    }
}

